# 🎵 Music Website – Technical Notes

This document summarizes current issues, potential fixes, and improvement ideas for the Music Website project.
The goal is to improve user experience, especially on iOS devices, and streamline playlist and playback functionality.

---

## 📚 Table of Contents

1. [Overview](#overview)
2. [iOS Compatibility](#1-ios-compatibility)

   * [Issues](#issues-1)
   * [Possible Fixes](#possible-fixes-1)
3. [Playlist Styling](#2-playlist-styling)

   * [Issues](#issues-2)
   * [Possible Fixes](#possible-fixes-2)
4. [Browse Songs (Search)](#3-browse-songs-search)

   * [Issues](#issues-3)
   * [Possible Fixes](#possible-fixes-3)
5. [Add Music (Tidal Integration)](#4-add-music-tidal-integration)

   * [Issues](#issues-4)
   * [Possible Fixes](#possible-fixes-4)

---

## Overview

The Music Website project currently faces several platform-specific and UX-related challenges.
This document outlines the key problems, identifies their likely causes, and suggests actionable solutions or workarounds.

---

## 1. iOS Compatibility

### Issues

1. **Background playback** does not automatically proceed to the next song when the app is not active (e.g., when the screen is off or another app is open).
2. The **Listen Together** feature is completely unsupported on iOS devices.

### Possible Fixes

1. **Improve main player functionality** to support full iOS background playback.

   * ✅ *Best long-term fix but may require extensive changes.*
2. **Develop a dedicated iOS player** and disable **Listen Together** for iOS users.

   * ⚙️ *Simpler to implement but less ideal for feature parity.*

---

## 2. Playlist Styling

### Issues

1. The **Reset** button currently creates a new stylesheet with default styles instead of resetting the existing one.
2. There is **no option to opt out** of playlist-specific styling.

### Possible Fixes

1. **Remove the Save button** if it has no functional effect.
2. **Refactor the styling logic** so that:

   * Styles are only saved when **Save Changes** is explicitly pressed.
   * Pressing **Reset** does not automatically generate a new stylesheet if none exists.
3. Add an **“Opt Out of Playlist Styling”** toggle in user preferences for users who prefer the default layout.

---

## 3. Browse Songs (Search)

### Issues

1. The **Load More Songs** button appears even when all available search results are already loaded.

### Possible Fixes

1. Disable or hide the **Load More Songs** button during search queries when no additional results exist.

---

## 4. Add Music (Tidal Integration)

### Issues

1. **Tidal integration** fails when attempting to download songs via `add-music.php`.

### Possible Fixes

1. Replace the **Tidal script** with the latest version to ensure compatibility with current APIs.

---

## 🧭 Next Steps

* Prioritize iOS playback issues for cross-platform consistency.
* Review playlist styling logic for unnecessary complexity.
* Update third-party integrations (Tidal and others) to maintain reliability.

---