# Notes on the Music Website

---

## 1. iOS

### Issues

1. Songs do not automatically play the next track when the music website is running in the background — for example, when another app is open or the device screen is turned off.
2. The **Listen Together** feature does not work on any iOS devices.

### Possible Fixes

1. Fix playback support for iOS by improving the main player functionality. *(Best long-term solution, but may not be practical.)*
2. Create a dedicated iOS-specific player and remove the **Listen Together** feature on iOS devices. *(Not ideal, but easier to implement.)*

---

## 2. Playlist Styling

### Issues

1. The **Reset** button on the playlist styling page does not perform its intended function; instead, it creates a new stylesheet with default styling.
2. There is no option for users to opt out of playlist styling entirely.

### Possible Fixes

1. Remove the **Save** button from the styling page if it serves no functional purpose.
2. Update the styling system so that:

   * Changes are only saved when the **Save Changes** button is pressed.
   * If **Reset** is pressed and no stylesheet exists, saving does not create a default stylesheet automatically.
3. Add an **Opt Out** toggle in user preferences to disable playlist-specific styling.

---

## 3. Browse Songs (Search)

### Issues

1. The **Load More Songs** button appears when searching, even if all search results are already displayed.

### Possible Fixes

1. Disable the **Load More Songs** button during searches when all results are already shown.

---

## 4. Add Music (Tidal Integration)

### Issues

1. Tidal throws an error when downloading songs through `add-music.php`.

### Possible Fixes

1. Replace the existing Tidal integration script with the latest version.