## [1.1.12] - 2025-09-14

### ⚠️ Breaking Changes

- **Directory Structure Change**: The indexer now indexes a `files/` subdirectory instead of the same directory as `index.php`
  - **Previous behavior**: `index.php` indexed its own directory
  - **New behavior**: `index.php` indexes `./files/` subdirectory
  - **Migration required**: Existing installations must create a `files/` directory and move content into it
  - **Impact**: Breaks existing installations without manual intervention

### Fixed

- **Cache Invalidation**: Resolved cache not updating when directory contents changed
  - Fixed cache not refreshing when new files were uploaded
  - Fixed cache not updating when directories were removed
  - Improved cache timestamp validation for real-time content changes
- **CSS Layout Issues**: 
  - Fixed options dropdown menu being cut off in certain browser configurations
  - Improved CSS styling for `icon_type: disabled` mode
  - Better layout handling when icons are completely disabled

### Enhanced

- **Directory Structure**: Cleaner separation between indexer files and indexed content
- **Cache Performance**: More reliable cache invalidation ensures users see current directory state
- **Interface Stability**: Better CSS positioning for dropdown menus and icon-disabled layouts

### Migration Guide

**For existing installations:**

1. **Create files directory:**
   ```bash
   mkdir files
   ```

2. **Move existing content:**
   ```bash
   # Move all content except indexer files
   mv !(index.php|.indexer_files) files/
   # Or manually move your content directories
   ```

3. **Update any bookmarks/links** to point to the new file paths

4. **Verify functionality** by accessing the indexer interface

**Note**: This change improves security by separating the indexer application from indexed content, but requires manual migration for existing installations.