## [1.1.18] - 2025-09-26

**Focus**: Enhanced Docker deployment and install script functionality with improved container management.

### Enhanced

- **Docker Container Management**: Smart configuration merging preserves user settings during updates
  - Version-aware config.json updating with automatic field addition
  - Backend file refresh ensures compatibility with current application version
  - Robust backup and recovery mechanisms prevent configuration loss
- **Installation Script Architecture**: Unified single-endpoint system for streamlined deployments
  - Consolidated version information and file listings for atomic updates
  - Selective file downloading reduces bandwidth and improves reliability
  - Comprehensive debugging with detailed progress tracking
- **File Browser Operations**: Restored proper functionality across all directory levels
  - Fixed file and folder actions in root directory that redirected to blocked pages
  - Restored missing file sharing options with complete operation capabilities
  - Enhanced validation prevents navigation errors

### Fixed

- **nginx Security Configuration**: Resolved overly restrictive dot folder blocking
  - Fixed critical issue preventing access to legitimate directories like `.ssh` and `.config`
  - Replaced blanket restrictions with targeted blocking of dangerous files (`.ht*`, `.git*`, `.env`, etc.)
  - Maintained security while allowing legitimate dot folder access
- **Docker Configuration Issues**: Multiple deployment and runtime improvements
  - Resolved configuration persistence problems during container restarts
  - Fixed version compatibility issues with backend file mismatches
  - Enhanced recovery system for missing configuration files
- **Core Application Functionality**: Critical bug fixes improving reliability
  - Fixed root directory operations and navigation consistency
  - Restored file sharing features for complete file management

### Performance

- **Container Efficiency**: Optimized Docker deployment with better resource utilization
  - Selective file management reduces initialization time
  - Smart configuration processing minimizes startup overhead
  - Enhanced caching improves rebuild performance
- **Installation Performance**: Streamlined deployment with reduced network overhead
  - Single network request eliminates multiple API calls
  - Bandwidth optimization through intelligent file filtering
  - Efficient regex-based parsing for faster analysis

### Security

- **Enhanced Access Control**: Improved security model with better functionality balance
  - Targeted file blocking replaces broad restrictions
  - Better HTTP status codes and error handling for blocked resources
  - Enhanced protection for sensitive configuration files
- **Robust Validation**: Enhanced input validation and error handling
  - Better directory traversal prevention with maintained access
  - Improved configuration file validation and input sanitization

### Technical Implementation

- **Container Startup Process**: Enhanced initialization with comprehensive validation
  - Proper environment setup and permission management
  - Force-update of backend files ensures compatibility
  - Smart configuration management preserves user settings
- **Installation Architecture**: Updated repository format and processing
  - First line contains version information, remaining lines provide file listings
  - Link grouping system with improved file structure
  - Regex-based parsing distinguishes directories from files

### Backward Compatibility

- **Seamless Migration**: Full compatibility with existing installations
  - Configuration preservation maintains all settings and customizations
  - Smooth Docker upgrade path without data loss
  - Mixed environment support allows coexistence of deployment methods