## [1.1.13] - 2025-09-16

### Added

- **Action Menu System**: Replaced download buttons with context-sensitive 3-dot action menus
  - Context-aware options: Open, Download, Share based on file permissions
  - Better space utilization and cleaner interface
- **Share System**: New share popup for copying file URLs
  - Manual URL copying interface replaces JavaScript clipboard functionality
  - Shareable links for files and folders
- **Mutual Exclusion Dropdowns**: Only one dropdown menu can be open at a time
  - Opening any menu automatically closes all others
  - Improved user experience and prevents interface conflicts

### Enhanced

- **Icon Display**: Increased icon size from 20px to 26px for better visibility
- **Header Alignment**: Improved column header positioning and clickability
  - Fixed SIZE column alignment with proper padding
  - Centered MODIFIED column with absolute positioning
  - Made header text clickable instead of full area
  - Prevented text wrapping in headers
- **Options Menu**: Better positioning and consistent button sizing
  - Fixed width (32px) and height (24px) for action buttons
  - Improved text centering and alignment
- **Dropdown Layering**: Proper z-index hierarchy
  - Buttons: z-index 100
  - Dropdowns: z-index 9999
  - Prevents menu overlap and display issues

### Fixed

- **Wildcard Exclusion Logic**: Separated access control from indexing logic
  - `"folder*"` blocks folder listing but allows subfolder access via direct URLs
  - `"folder/*"` recursively blocks all access including subfolders
  - More intuitive pattern behavior
- **File Access Security**: Enhanced security for raw file viewing
  - Raw file viewer now checks current deny/allow lists and viewable settings
  - Files added to deny list redirect to main index instead of displaying
  - Non-viewable files redirect instead of repeatedly attempting downloads
- **Download Permission Enforcement**: Stricter permission handling
  - Non-viewable files properly respect `disable_file_downloads` setting
  - Disabled downloads return placeholder links instead of broken functionality
- **Icon Positioning**: Adjusted icon alignment with margin-left: -8px for better spacing

### Security

- **Nginx Configuration**: Enhanced default security configuration
  - Direct file access blocked except for `local_api` related files
  - All file access now routed exclusively through the indexer
  - Prevents bypassing indexer security controls

### Interface

- **Action Menu Integration**: Seamless replacement of old download button system
  - More intuitive file interaction model
  - Better mobile compatibility
  - Consistent styling across all action elements