## [1.1.0] - 2025-09-12

### Added

#### New File Type Support
- **Build System Files**: Added support for Gradle properties, Maven POM files, and CMake files
- **Project Configuration**: Support for Visual Studio solutions, Xcode projects, and workspace configurations
- **Logging Frameworks**: Full support for Logback, Log4j, SLF4J, Winston, Bunyan, Pino, and other logging systems
- **Web Frameworks**: Added support for Express.js, Koa.js, Fastify, Hapi.js, NestJS, and other Node.js frameworks
- **Frontend Frameworks**: Support for Next.js, Nuxt.js, Gatsby, SvelteKit framework files
- **Database & ORM**: Added TypeORM, Sequelize, Mongoose, Prisma, and other database framework files
- **Security & Middleware**: Support for Helmet.js, CORS configuration, and security middleware files
- **GraphQL Ecosystem**: Added Apollo, Relay, and GraphQL schema files
- **Real-time Communication**: Support for Socket.IO and WebSocket library files
- **Audio Format**: Added FLAC (Free Lossless Audio Codec) support with proper headers

#### Enhanced File Types
- **Audio Files**: Improved AAC, OGG, and M4A file handling
- **Image Files**: Enhanced ICO, CUR, AVIF, and SVG support with better MIME types
- **Vector Graphics**: Better SVG integration with proper content type headers

### Enhanced

#### File Viewing
- **FLAC Audio**: Added proper `audio/flac` MIME type headers for browser playback
- **Icon System**: Improved icon mapping for new file types
- **Extension Mappings**: Expanded extension-to-configuration mappings for better file recognition

#### Developer Experience
- **Framework Support**: Comprehensive coverage of modern development frameworks and tools
- **Build Tools**: Enhanced support for contemporary build systems and project files
- **Logging Systems**: Better integration with popular logging frameworks across multiple languages

### Fixed

- **Audio Headers**: Fixed MIME type handling for various audio formats
- **File Recognition**: Improved accuracy of file type detection for specialized formats
- **Icon Display**: Better icon resolution for development and framework files

### Configuration Updates

#### New Configuration Keys
- **Build & Project Files**: `rebar`, `lein`, `project`, `solution`, `vcxproj`, `xcodeproj`, `workspace`, `pbxproj`
- **Properties Files**: `gradle.properties`, `local.properties`, `application.properties`, `bootstrap.properties`
- **Logging Frameworks**: `logback`, `log4j`, `slf4j`, `commons-logging`, `tinylog`, `loguru`, `winston`, `bunyan`, `pino`, `morgan`
- **Web Frameworks**: `express`, `koa`, `fastify`, `hapi`, `restify`, `nest`, `meteor`, `nuxt`, `next`, `gatsby`, `sveltekit`
- **Database & ORM**: `prisma`, `typeorm`, `sequelize`, `mongoose`, `knex`, `bookshelf`, `objection`, `waterline`, `sails`, `feathers`
- **Security & Real-time**: `helmet`, `cors`, `socketio`, `ws`, `graphql`, `apollo`, `relay`
- **Audio**: `flac` with proper viewing and indexing configuration

#### Updated Configurations
- Enhanced default settings for new file types
- Improved security defaults for framework configuration files
- Better viewing preferences for development-related files

### Technical Improvements

- **MIME Type System**: Enhanced content type detection and header configuration
- **Icon Mapping**: Expanded icon associations for new file types
- **Performance**: Optimized file type recognition for larger codebases
- **Compatibility**: Maintained backward compatibility with existing configurations