## [1.2.0-r0] - 2025-10-02

### Added

- **Security Bar**: New header interface for file viewing
  - Security indicator showing HTTPS/HTTP connection status with visual lock icon
  - File name display in header for better context
  - Integrated view mode controls (Raw/Code/Markdown buttons)
  - Clean, accessible design with tooltips for security status
- **Enhanced Code Highlighting**: Integrated Scrivo's highlight.php library
  - Support for 100+ programming languages
  - Syntax-aware rendering with line numbers
  - Automatic language detection from file extensions
  - Fallback to plain text for unsupported formats

### Changed

- **Docker Volume Structure**: Simplified mount configuration
  - `/config` mount now contains only `config.json` and `config-reference.txt`
  - New `/app` mount for `.indexer_files` content (icons, favicon, local_api, php, caches)
  - Reduced host filesystem exposure - only essential config files externally accessible
  - Optional `/app` mount available for users requiring full access to indexer files
- **File Viewer Interface**: View mode buttons relocated to security bar
  - Removed buttons from main content area for cleaner layout
  - Consistent interface across all file types
  - Improved mobile responsiveness

### Technical

- **Volume Organization**: Separation of config and application files
  - Config symlinks created in `/app` for PHP accessibility
  - Maintained backward compatibility with existing installations
  - Streamlined initialization process for faster container startup
- **Caching**: File view caching with modification time tracking
  - Cached rendered output includes security bar and view modes
  - Automatic cache invalidation on file changes

### Security

- **Connection Awareness**: Visual indication of HTTPS vs HTTP connections
  - Green lock icon for secure HTTPS connections
  - Red lock icon for unencrypted HTTP connections
  - Encourages secure deployment practices
- **Reduced Attack Surface**: Minimized host-accessible files
  - Only configuration files exposed through `/config` mount
  - Application internals isolated in container unless explicitly mounted