## [1.2.0-r2] - 2025-10-11

### Note
This release primarily focuses on installer improvements. The 5q12 Indexer webapp itself contains only minor CSS fixes, with all other changes affecting the `install.sh` installation script.

### Added

- **Dynamic Source Installation**: New `-source` flag for flexible file downloads
  - `-source -all` downloads complete repository
  - `-source -<path>` downloads specific directories (e.g., `-source -docker`)
  - Supports nested paths (e.g., `-source -docker/source/config`)
  - Single file downloads (e.g., `-source -index.php`, `-source -docker/build.sh`)
  - Dynamic pattern matching eliminates hardcoded source paths

### Enhanced

- **Install Script Auto-Update**: Installer now self-updates during update process
  - Downloads latest `install.sh` from repository
  - Validates syntax before replacement
  - Compares versions and notifies user of changes
  - Ensures installation process stays current with latest improvements

### Fixed

- **Dependency Installation Reliability**: Two-pass dependency verification
  - Re-checks all dependencies after initial installation
  - Catches PHP extensions that require base packages first
  - Ensures SQLite3 and all required extensions properly installed
  - Eliminates need for manual reinstallation attempts
- **Code Viewer Mobile CSS**: Minor adjustments to improve rendering on mobile devices

### Technical

- **SQLite3 Package Coverage**: Comprehensive library installation
  - Includes `libsqlite3-0`, `libsqlite3-dev`, and `sqlite3` CLI
  - PHP SQLite3 extension with automatic FPM restart
  - Post-installation verification for both CLI and PHP module