## [2.0.0-r0] - 2025-10-19

### Note
This is a major release introducing significant architectural improvements and extensive new features. Version 2.0 represents a complete overhaul of the backend systems with new database architecture, comprehensive media viewers, and enhanced performance.

### Added

- **Complete Audio Player System**: Full-featured audio playback with metadata support
  - Support for 14 audio formats (MP3, WAV, AAC, FLAC, M4A, OGG, OGA, OPUS, AIFF, AIF, AIFC, WMA, DSF, DFF)
  - getID3 library integration for metadata extraction (title, artist, album, year, genre, bitrate, sample rate)
  - Cover art display with fallback to file type icons
  - HTML5 native audio controls with no JavaScript required
  - Technical audio information display (duration, channels, file size)
  - Responsive mobile layout matching existing design system

- **Advanced Image Viewer**: Dedicated image viewing interface with extensive format support
  - Support for 17+ image formats including RAW camera formats (CR2, CR3, NEF, ARW, etc.)
  - Modern format support (AVIF, HEIC, WebP, SVG)
  - Design format support (PSD, AI, Fig, Sketch, XCF)
  - Dual viewing modes: Fit to Screen and True Scale
  - Image conversion system using ImageMagick/GD for unsupported formats
  - Comprehensive image information display (dimensions, type, file size, modification date)
  - Security bar with Raw/View toggle and action buttons

- **Dual-System Architecture**: Complete separation of persistent and temporary data
  - **Database System** (`Database.php`): SQLite-based persistent storage for configuration and file metadata
  - **Cache System** (`Cache.php`): Intelligent temporary storage for generated content
  - Auto-initialization with zero manual setup required
  - MD5 hash-based cache naming to prevent collisions
  - Modification time tracking for automatic cache invalidation

- **Enhanced Markdown Viewer**: Significantly improved markdown rendering capabilities
  - Relative link resolution with automatic `/?view=default` appending
  - Anchor link support with auto-generated IDs and scroll offset
  - Raw HTML tag preservation and rendering
  - HTML entity preservation (`&ensp;`, `&nbsp;`, etc.)
  - Relative image path resolution for both markdown and HTML syntax
  - Image dimension and alignment handling with inline styles

- **Comprehensive CLI Tools**: Command-line management for system administration
  - **Database Management**: Initialize, optimize, and manage database operations
  - **Cache Management**: View statistics, clear specific caches, show directory paths
  - **System Initialization**: Auto-setup tools for troubleshooting and maintenance

### Enhanced

- **Performance Optimization**: Dramatic speed improvements across the board
  - First load: 5-30 seconds (one-time indexing)
  - Subsequent loads: <1 second (instant database reads)
  - 10-50x faster page loads after initialization
  - Intelligent caching eliminates redundant file system scanning

- **Format Support Expansion**: Massive increase in supported file types
  - Audio formats expanded from 8 to 14 supported types
  - Image formats expanded to 17+ including RAW and design formats
  - New MIME type mappings for improved browser compatibility
  - Browser compatibility warnings for limited-support formats

- **Configuration System**: Enhanced control over file handling
  - Individual format viewing controls via `config.json`
  - RAW image viewing controls with security considerations
  - Maximum resolution limits for automatic image conversion
  - Comprehensive indexing and viewing permission system

### Technical

- **Database Schema**: Optimized SQLite database structure
  - `system_config`: Complete configuration storage as JSON
  - `extension_mappings`: Extension-to-setting mappings
  - `icon_mappings`: Icon filename associations
  - `file_metadata`: Indexed file information with optimized queries
  - Automatic indexing on frequently queried fields

- **Cache Architecture**: Multi-tier caching system
  - **Files Cache**: Rendered code/markdown content
  - **Image Cache**: Converted and processed images
  - **Zip Cache**: Temporary archive files and extraction directories
  - **Version Cache**: Application version information with 2-hour TTL

- **File Structure Reorganization**: Cleaner separation of concerns
  - Database files in `.indexer_files/db/`
  - Cache files in `.indexer_files/cache/`
  - Proper permission handling (0777 directories, 0666 files)
  - Self-healing system that rebuilds if components are deleted

### Migration

- **Legacy System Obsolescence**: Previous caching system replaced
  - Old `IndexerCache.php` system deprecated
  - Previous `.indexer_files/index_cache/` directory structure obsoleted
  - Old `.indexer_files/zip_cache/` directory structure replaced
  - Automatic migration path with backward compatibility

### Fixed

- **MIME Type Corrections**: Fixed incorrect MIME types in URL router
  - Corrected AIFF format MIME types (AIF, AIFC)
  - Added missing OGA audio MIME type
  - Updated DSD format handling (DSF, DFF)

- **Mobile Responsiveness**: Improved mobile experience across all viewers
  - Audio player mobile layout optimization
  - Image viewer responsive design improvements
  - Markdown viewer mobile compatibility enhancements

### Security

- **RAW Format Controls**: Security-focused RAW image handling
  - Default disabled RAW format viewing (`disable_raw_image_viewing: true`)
  - Configurable RAW format access controls
  - Secure conversion pipeline for enabled RAW formats

### Performance

- **Scalability Improvements**: Enhanced handling of large file collections
  - Database indexing for optimal query performance
  - Intelligent file system scanning (one-time operation)
  - Cached metadata prevents repeated file system access
  - Memory-efficient image processing with resolution limits

### Developer Experience

- **Clean API Design**: Well-structured codebase for future development
  - Clear separation between database and cache operations
  - Extensible architecture for additional format support
  - No external dependencies beyond standard PHP + SQLite