<?php
// Fetch the latest version from the API
$versionUrl = 'api/2.0/latest/latest.txt';
$latestVersion = '2.1.1'; // Fallback version

try {
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . $versionUrl)) {
        $latestVersion = trim(file_get_contents($_SERVER['DOCUMENT_ROOT'] . $versionUrl));
    } else {
        // Try fetching from URL if local file doesn't exist
        $versionContent = @file_get_contents('https://games.ccls.icu/CLI/api/2.0/latest/latest.txt');
        if ($versionContent !== false) {
            $latestVersion = trim($versionContent);
        }
    }
} catch (Exception $e) {
    // Use fallback version if there's any error
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CCLS Games CLI Tool - Home</title>
    <link rel="icon" type="image/x-icon" href="/favicon/icon.ico">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon/16x16.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon/32x32.png">
    <link rel="icon" type="image/png" sizes="48x48" href="/favicon/48x48.png">
    <link rel="icon" type="image/png" sizes="96x96" href="/favicon/96x96.png">
    <link rel="icon" type="image/png" sizes="144x144" href="/favicon/144x144.png">
    <link rel="icon" type="image/png" sizes="192x192" href="/favicon/192x192.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/favicon/180x180.png">
    <link rel="manifest" href="/manifest.json">
    <style>
        :root {
            --primary-color: #7B68EE;
            --primary-hover: #9370DB;
            --secondary-color: #6A5ACD;
            --background-color: #121212;
            --surface-color: #1E1E1E;
            --text-color: #E0E0E0;
            --text-muted: #AAAAAA;
            --success-color: #4CAF50;
            --warning-color: #FF9800;
            --error-color: #F44336;
            --note-color: #2196F3;
            --code-background: #2D2D2D;
            --border-color: #333333;
            --border-radius: 8px;
            --glow-effect: 0 0 10px rgba(123, 104, 238, 0.3);
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: var(--background-color);
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }

        h1 {
            color: var(--primary-color);
            border-bottom: 2px solid var(--primary-color);
            padding-bottom: 10px;
            margin-bottom: 30px;
            text-shadow: 0 0 5px rgba(123, 104, 238, 0.3);
        }

        h2 {
            color: var(--primary-color);
            margin-top: 30px;
        }

        h3 {
            color: var(--text-color);
        }

        .container {
            background-color: var(--surface-color);
            border-radius: var(--border-radius);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            padding: 25px;
            margin-bottom: 30px;
            border: 1px solid #333;
        }

        a {
            color: var(--primary-color);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        a:hover {
            color: var(--primary-hover);
            text-decoration: underline;
        }

        .step {
            margin-bottom: 40px;
            position: relative;
            padding-left: 50px;
            transition: all 0.3s ease;
        }

        .step:hover {
            transform: translateY(-2px);
        }

        .step-number {
            position: absolute;
            left: 0;
            top: 0;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            box-shadow: var(--glow-effect);
        }

        .code-block {
            background-color: var(--code-background);
            border-left: 4px solid var(--primary-color);
            padding: 15px;
            margin: 15px 0;
            border-radius: 0 var(--border-radius) var(--border-radius) 0;
            overflow-x: auto;
            font-family: Consolas, Monaco, 'Andale Mono', monospace;
            box-shadow: inset 0 0 10px rgba(0, 0, 0, 0.2);
            color: #FFF;
        }

        code {
            background-color: rgba(123, 104, 238, 0.1);
            color: var(--primary-color);
            padding: 2px 5px;
            border-radius: 3px;
            font-family: Consolas, Monaco, 'Andale Mono', monospace;
        }

        .note {
            background-color: rgba(33, 150, 243, 0.1);
            border-left: 4px solid var(--note-color);
            padding: 15px;
            margin: 15px 0;
            border-radius: 0 var(--border-radius) var(--border-radius) 0;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .warning {
            background-color: rgba(255, 152, 0, 0.1);
            border-left: 4px solid var(--warning-color);
            padding: 15px;
            margin: 15px 0;
            border-radius: 0 var(--border-radius) var(--border-radius) 0;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .success {
            background-color: rgba(76, 175, 80, 0.1);
            border-left: 4px solid var(--success-color);
            padding: 15px;
            margin: 15px 0;
            border-radius: 0 var(--border-radius) var(--border-radius) 0;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        img {
            max-width: 100%;
            border-radius: var(--border-radius);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
            margin: 15px 0;
            border: 1px solid var(--border-color);
        }

        .btn {
            display: inline-block;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 10px 20px;
            border-radius: var(--border-radius);
            text-decoration: none;
            margin-top: 10px;
            transition: all 0.3s;
            box-shadow: var(--glow-effect);
        }

        .btn:hover {
            background: linear-gradient(135deg, var(--primary-hover), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(123, 104, 238, 0.4);
        }

        .requirements {
            background-color: #252525;
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            border: 1px solid var(--border-color);
        }

        .requirements ul {
            margin: 10px 0 0 0;
            padding-left: 20px;
            color: var(--text-muted);
        }
        
        .requirements li {
            margin-bottom: 5px;
        }

        strong {
            color: #FFF;
            font-weight: 600;
        }

        .welcome-panel {
            background: linear-gradient(145deg, #252525, #1a1a1a);
            padding: 25px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .welcome-panel::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
        }

        .welcome-panel h2 {
            margin-top: 0;
            margin-bottom: 15px;
            color: #FFF;
            font-size: 24px;
        }

        .welcome-panel p {
            color: var(--text-muted);
            margin-bottom: 20px;
            font-size: 16px;
            line-height: 1.6;
        }

        .download-btn {
            display: inline-flex;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 12px 25px;
            border-radius: var(--border-radius);
            text-decoration: none;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s;
            box-shadow: var(--glow-effect);
            margin-top: 10px;
            margin-right: 15px;
        }

        .download-btn:hover {
            background: linear-gradient(135deg, var(--primary-hover), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(123, 104, 238, 0.5);
            text-decoration: none;
            color: white;
        }

        .archive-btn {
            display: inline-flex;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 12px 25px;
            border-radius: var(--border-radius);
            text-decoration: none;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s;
            box-shadow: var(--glow-effect);
            margin-top: 10px;
        }

        .archive-btn:hover {
            background: linear-gradient(135deg, var(--primary-hover), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(123, 104, 238, 0.5);
            text-decoration: none;
            color: white;
        }

        .download-icon {
            font-size: 18px;
            margin-right: 10px;
            display: inline-block;
            animation: bounce 2s infinite;
        }

        .archive-icon {
            font-size: 18px;
            margin-right: 10px;
            display: inline-block;
            animation: bounce 2s infinite;
        }

        .button-container {
            display: flex;
            flex-wrap: wrap;
            gap: 0;
            align-items: center;
        }

        .back-to-games-btn {
            display: inline-flex;
            align-items: center;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 10px 20px;
            border-radius: var(--border-radius);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s;
            box-shadow: var(--glow-effect);
            margin-bottom: 20px;
            position: relative;
            top: 0;
            left: 0;
        }

        .back-to-games-btn:hover {
            background: linear-gradient(135deg, var(--primary-hover), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(123, 104, 238, 0.5);
            text-decoration: none;
            color: white;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-5px);
            }
            60% {
                transform: translateY(-3px);
            }
        }

        @media (max-width: 600px) {
            body {
                padding: 10px;
            }
            .step {
                padding-left: 40px;
            }
            .button-container {
                flex-direction: column;
                align-items: stretch;
            }
            .download-btn, .archive-btn {
                margin-right: 0;
                margin-bottom: 10px;
                text-align: center;
            }
            .back-to-games-btn {
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="https://games.ccls.icu/" class="back-to-games-btn">
            ← Back To Games
        </a>
        
        <h1>CLI Tool Installation Guide</h1>
        
        <div class="welcome-panel">
            <h2>CCLS Games CLI Tool v<?php echo htmlspecialchars($latestVersion); ?></h2>
            <p>Hello and welcome to the CCLS Games CLI Tool. This PowerShell script is meant to be used as a fairly simple command line tool for downloading and managing games from our website.</p>
            <div class="button-container">
                <a href="https://games.ccls.icu/CLI/api/2.0/latest/CLI.ps1" class="download-btn">
                    <span class="download-icon">↓</span> Download CLI Tool
                </a>
                <a href="web/archive.php" class="archive-btn">
                    <span class="archive-icon">📦</span> Archived Versions
                </a>
            </div>
        </div>
        
        <div class="requirements">
            <h3>Prerequisites:</h3>
            <ul>
                <li>Windows 10 or 11 operating system</li>
                <li>Administrator access to your computer</li>
                <li>Internet connection</li>
                <li>A CCLS Games account (sign up during setup if you don't have one)</li>
            </ul>
        </div>

        <div class="step">
            <div class="step-number">1</div>
            <h2>Create a Dedicated Folder</h2>
            <p>First, create a new folder anywhere on your computer where you'd like to store the script.</p>
            <div class="note">
                <strong>Tip:</strong> Consider creating this folder in an easy-to-access location like your Documents folder or Desktop.
            </div>
            <p>Once you've created the folder, place the <code>CLI.ps1</code> PowerShell script inside it.</p>
        </div>

        <div class="step">
            <div class="step-number">2</div>
            <h2>Configure PowerShell Security Settings</h2>
            <p>PowerShell has security features that prevent unauthorized scripts from running. We need to adjust these settings to run the script:</p>
            <ol>
                <li>Click on the Start menu</li>
                <li>Type "PowerShell"</li>
                <li>Right-click on "Windows PowerShell" and select "Run as administrator"</li>
                <li>When PowerShell opens, enter the following command:</li>
            </ol>
            <div class="code-block">
                Set-ExecutionPolicy RemoteSigned -Scope CurrentUser
            </div>
            <p>When prompted to confirm the change, type <strong>A</strong> (for "Yes to All") and press Enter.</p>
            <div class="warning">
                <strong>Note:</strong> This setting allows you to run local scripts while still requiring downloaded scripts to be signed by a trusted publisher. This is safer than completely disabling security protections.
            </div>
        </div>

        <div class="step">
            <div class="step-number">3</div>
            <h2>First Run: Handle Security Warning and Login</h2>
            <p>Now you're ready to run the script for the first time. This involves handling a Windows security prompt and logging into your account:</p>
            
            <h3>Windows Security Warning</h3>
            <ol>
                <li>Navigate to the folder where you placed <code>CLI.ps1</code></li>
                <li>Right-click on the <code>CLI.ps1</code> file</li>
                <li>Select "Run with PowerShell" from the context menu</li>
                <li>Windows will show a security warning dialog</li>
            </ol>
            
            <div class="warning">
                <strong>Important Security Tip:</strong> In the security dialog, you'll see a checkbox that says "Always ask before opening this file". 
                <strong>Uncheck this box</strong> before clicking "Open" - otherwise Windows will show this warning every time you run the script, which can be annoying.
            </div>
            
            <h3>Login or Create Account</h3>
            <p>After the script starts, you'll be prompted to log in:</p>
            <ul>
                <li><strong>If you have an account:</strong> Enter your username and password</li>
                <li><strong>If you don't have an account:</strong> The script will display a link to create one at <a href="https://web/www/games/login.php?signup" target="_blank">https://web/www/games/login.php?signup</a></li>
            </ul>
            
            <div class="note">
                <strong>Save Login Info:</strong> After successful login, the script will ask if you want to remember your login information for next time. 
                Choose "Y" if you want to automatically log in on future runs (recommended for convenience).
            </div>
        </div>

        <div class="step">
            <div class="step-number">4</div>
            <h2>Check System Requirements</h2>
            <p>Once logged in, you should check what components you need to install for full functionality:</p>
            <div class="code-block">
                CCLS>check
            </div>
            
            <div class="note">
                <strong>Important:</strong> The CLI Tool will check your system and tell you exactly what components you need to install. All components listed below are now required for script operation:
                <ul>
                    <li><strong>7-Zip</strong> - <strong>REQUIRED</strong> for extracting game files after downloading. Games cannot be installed without this component.</li>
                    <li><strong>Python</strong> - <strong>REQUIRED</strong> for download functionality. Provides a much faster download experience (up to 10x faster).</li>
                    <li><strong>Python requests library</strong> - <strong>REQUIRED</strong> if Python is installed. This library is essential for the download system to function properly.</li>
                </ul>
            </div>
        </div>

        <div class="step">
            <div class="step-number">5</div>
            <h2>Install Required Components</h2>
            <p>Based on the <code>check</code> results, you can install the required components directly from the CLI Tool:</p>
            
            <h3>Installing 7-Zip (Required)</h3>
            <p>7-Zip is <strong>required</strong> to extract downloaded game files. Without it, games cannot be installed properly.</p>
            <div class="code-block">
                CCLS>install 7zip
            </div>
            
            <h3>Installing Python (Required)</h3>
            <p>Python is required for download functionality. Install it with:</p>
            <div class="code-block">
                CCLS>install python
            </div>
            <div class="note">
                <strong>Tip:</strong> When installing Python, make sure to check "Add Python to PATH" in the installer to enable all CLI Tool features.
            </div>
            <div class="warning">
                <strong>Important:</strong> Once Python installation is finished and you have closed the installer, CLI Tool needs to be restarted for Python to be recognized by CLI Tool properly.
            </div>
            
            <h3>Installing Python Requests Library (Required)</h3>
            <p>The requests library is needed for the download system to function. Install it with:</p>
            <div class="code-block">
                CCLS>install requests
            </div>
            <div class="note">
                <strong>Tip:</strong> If the <code>install requests</code> command returns an error about Python not being found, make sure you restarted CLI Tool after Python installation.
            </div>
            
            <div class="success">
                <strong>Success:</strong> After installing these components, your CLI Tool will be fully functional with the best performance. The tool will guide you through each installation process.
            </div>
        </div>

        <div class="step">
            <div class="step-number">6</div>
            <h2>Run the Setup Command</h2>
            <p>Before downloading any games, you <strong>must</strong> run the <code>setup</code> command to configure your download directories:</p>
            <div class="code-block">
                CCLS>setup
            </div>
            <p>The setup process will ask you to specify two important directories:</p>
            <ol>
                <li><strong>Games installation directory</strong> - This is where your downloaded games will be installed</li>
                <li><strong>Temporary download directory</strong> - This is where game files will be temporarily stored during download before being extracted</li>
            </ol>
            <div class="warning">
                <strong>Important:</strong> The setup step is mandatory. You cannot download games until you've completed this configuration.
            </div>
            <div class="note">
                <strong>Tip:</strong> Choose directories with plenty of free space, especially for the games installation directory. Some games can be quite large.
            </div>
        </div>

        <div class="step">
            <div class="step-number">7</div>
            <h2>Using the CLI Tool</h2>
            <p>Once you have installed the necessary components and completed setup, you can start using the CLI Tool. The tool has an extensive help system:</p>
            
            <h3>Essential Commands</h3>
            <ul>
                <li><code>help</code> - Display basic help and overview of commands</li>
                <li><code>help -a</code> - Show a comprehensive list of all available commands</li>
                <li><code>search library</code> - List all available games and bundles</li>
                <li><code>get [game_id]</code> - Download and install a game</li>
                <li><code>browse</code> - Interactive browser for installed games</li>
                <li><code>list all</code> - Show all your installed games</li>
            </ul>
            
            <div class="note">
                <strong>Quick Start:</strong> Type <code>search library</code> to see all available games, then use <code>get [game_id]</code> to download one!
            </div>
            
            <h3>Basic Workflow</h3>
            <div class="success">
                <strong>Example workflow:</strong>
                <ol>
                    <li>Type <code>search library</code> to see all available games</li>
                    <li>Find a game you want and note its ID (e.g., cg0025)</li>
                    <li>Type <code>get cg0025</code> to download and install it</li>
                    <li>Use <code>browse</code> to manage your installed games</li>
                </ol>
            </div>
        </div>

        <div class="step">
            <div class="step-number">8</div>
            <h2>Troubleshooting</h2>
            <p>If you encounter any issues:</p>
            <div class="warning">
                <strong>Common Issue #1:</strong> If you get an error about missing dependencies when trying to download games, make sure you've run the install commands for all required components (7zip, python, requests).
            </div>
            <div class="warning">
                <strong>Common Issue #2:</strong> If PowerShell shows an error about execution policy, make sure you ran the Set-ExecutionPolicy command correctly in Step 2.
            </div>
            <div class="warning">
                <strong>Common Issue #3:</strong> If you get an error saying "you must run the 'setup' command before downloading", make sure you've completed the setup process in Step 6.
            </div>
            <div class="warning">
                <strong>Common Issue #4:</strong> If Windows keeps showing the security warning, make sure you unchecked "Always ask before opening this file" when you first ran the script.
            </div>
            <div class="warning">
                <strong>Common Issue #5:</strong> If you see messages about the CLI Tool being in a "broken state" or missing critical dependencies, run the <code>check</code> command to see what components need to be installed.
            </div>
            <div class="note">
                <strong>Remember:</strong> The <code>check</code> command is your best friend for troubleshooting. It will tell you exactly what components are missing or need to be updated.
            </div>
        </div>
    </div>

    <script>
        // Add a simple animation for the steps
        document.addEventListener('DOMContentLoaded', function() {
            const steps = document.querySelectorAll('.step');
            steps.forEach((step, index) => {
                step.style.opacity = '0';
                step.style.transform = 'translateY(20px)';
                step.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                
                setTimeout(() => {
                    step.style.opacity = '1';
                    step.style.transform = 'translateY(0)';
                }, 100 * index);
            });
        });
    </script>
</body>
</html>