<?php
// CLI/api/2.0/get.php - Download URL retrieval for CLI (for both games and bundles)

// Allow CORS from CLI
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');

// Check if username and password were provided
if (!isset($_POST['username']) || empty($_POST['username'])) {
    echo json_encode([
        'success' => false,
        'message' => 'You are running an outdated script version run [update] to fix this issue'
    ]);
    exit;
}

if (!isset($_POST['password']) || empty($_POST['password'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Password is required'
    ]);
    exit;
}

$username = trim($_POST['username']);
$password = trim($_POST['password']);

// Verify user credentials - Updated path for v2.0
$user_files = glob("../../../users/*.json");
$user_authenticated = false;

foreach ($user_files as $file) {
    $user_data = json_decode(file_get_contents($file), true);
    
    if ($user_data['username'] === $username) {
        // Verify password
        if (password_verify($password, $user_data['password'])) {
            $user_authenticated = true;
        }
        break;
    }
}

// If authentication failed, return error
if (!$user_authenticated) {
    echo json_encode([
        'success' => false,
        'message' => 'Authentication failed'
    ]);
    exit;
}

// Check if ID is provided
if (!isset($_POST['id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'ID is required'
    ]);
    exit;
}

$id = $_POST['id'];

// Determine if this is a game or bundle ID based on prefix
$is_bundle = (strpos($id, 'cb') === 0);

if ($is_bundle) {
    $file_path = "../../../bundles/{$id}.json";
    $type = "bundle";
} else {
    $file_path = "../../../titles/{$id}.json";
    $type = "game";
}

// Check if file exists
if (!file_exists($file_path)) {
    echo json_encode([
        'success' => false,
        'message' => ucfirst($type) . ' not found'
    ]);
    exit;
}

// Load data
try {
    $data = json_decode(file_get_contents($file_path), true);
    
    // Check if download URL exists
    if (!isset($data['download_url']) || empty($data['download_url'])) {
        echo json_encode([
            'success' => false,
            'message' => 'Download URL not available for this ' . $type
        ]);
        exit;
    }
    
    // Return only the necessary information for downloading
    $response = [
        'success' => true,
        'id' => $data['id'],
        'name' => $data['name'],
        'download_url' => $data['download_url'],
        'type' => $type
    ];
    
    // Add size information depending on type
    if ($is_bundle) {
        $response['size'] = isset($data['zipped_size']) ? $data['zipped_size'] : 'Unknown';
    } else {
        $response['size'] = isset($data['size']) ? $data['size'] : 'Unknown';
    }
    
    echo json_encode($response);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error loading ' . $type . ' data: ' . $e->getMessage()
    ]);
}
?>