<?php
// CLI/api/2.0/list.php - Return all available games and bundles in a list format for CLI

// Allow CORS from CLI
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');

// Check if username and password were provided
if (!isset($_POST['username']) || empty($_POST['username'])) {
    echo json_encode([
        'success' => false,
        'message' => 'You are running an outdated script version run [update] to fix this issue'
    ]);
    exit;
}

if (!isset($_POST['password']) || empty($_POST['password'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Password is required'
    ]);
    exit;
}

$username = trim($_POST['username']);
$password = trim($_POST['password']);

// Verify user credentials - Updated path for v2.0
$user_files = glob("../../../users/*.json");
$user_authenticated = false;

foreach ($user_files as $file) {
    $user_data = json_decode(file_get_contents($file), true);
    
    if ($user_data['username'] === $username) {
        // Verify password
        if (password_verify($password, $user_data['password'])) {
            $user_authenticated = true;
        }
        break;
    }
}

// If authentication failed, return error
if (!$user_authenticated) {
    echo json_encode([
        'success' => false,
        'message' => 'Authentication failed'
    ]);
    exit;
}

// Initialize response
$response = [
    'success' => true,
    'games' => [],
    'bundles' => []  // New array to store bundles
];

// Get all game JSON files - Updated path for v2.0
$game_files = glob("../../../titles/*.json");
$games_list = [];

// Process each game file
foreach ($game_files as $file) {
    try {
        // Load game data
        $game_data = json_decode(file_get_contents($file), true);
        
        // If valid game data, add to list
        if (isset($game_data['id']) && isset($game_data['name'])) {
            $games_list[] = [
                'id' => $game_data['id'],
                'name' => $game_data['name']
            ];
        }
    } catch (Exception $e) {
        // Skip files that can't be processed
        continue;
    }
}

// Get all bundle JSON files - Updated path for v2.0
$bundle_files = glob("../../../bundles/*.json");
$bundles_list = [];

// Process each bundle file
foreach ($bundle_files as $file) {
    try {
        // Load bundle data
        $bundle_data = json_decode(file_get_contents($file), true);
        
        // If valid bundle data, add to list
        if (isset($bundle_data['id']) && isset($bundle_data['name'])) {
            $bundles_list[] = [
                'id' => $bundle_data['id'],
                'name' => $bundle_data['name']
            ];
        }
    } catch (Exception $e) {
        // Skip files that can't be processed
        continue;
    }
}

// Sort games by name
usort($games_list, function($a, $b) {
    return strcasecmp($a['name'], $b['name']);
});

// Sort bundles by name
usort($bundles_list, function($a, $b) {
    return strcasecmp($a['name'], $b['name']);
});

$response['games'] = $games_list;
$response['bundles'] = $bundles_list;
$response['count'] = count($games_list);
$response['bundle_count'] = count($bundles_list);  // Add bundle count

// Return the games and bundles list as JSON
echo json_encode($response);
?>