# Troubleshooting Guide

Comprehensive troubleshooting guide for common issues with the CCLS Games CLI Tool.

## Table of Contents

1. [Quick Diagnostics](#quick-diagnostics)
2. [Installation Issues](#installation-issues)
3. [Login and Authentication](#login-and-authentication)
4. [Download Problems](#download-problems)
5. [Extraction and Installation](#extraction-and-installation)
6. [Performance Issues](#performance-issues)
7. [System Compatibility](#system-compatibility)
8. [Network and Connectivity](#network-and-connectivity)
9. [Cache and Data Issues](#cache-and-data-issues)
10. [Advanced Troubleshooting](#advanced-troubleshooting)

## Quick Diagnostics

### Clean Installation Process

If all else fails, perform a clean installation:
1. **Backup Data**:
   - Export game list: `list all > games_backup.txt`
   - Copy settings folder
   - Note installation directories
2. **Clean Removal**:
   - Delete CLI Tool directory
   - Clear PowerShell execution policy (optional)
3. **Fresh Installation**:
   - Download latest CLI.ps1
   - Follow installation guide
   - Restore settings if needed

### Getting Additional Help

If troubleshooting doesn't resolve your issue:

1. **Documentation Review**:
   - Check [Installation Guide](installation.md)
   - Review [User Guide](user-guide.md)
   - Verify [Commands Reference](commands.md)

2. **Log Information**:
   - Collect recent log files
   - Note exact error messages
   - Document steps to reproduce

3. **System Information**:
   - Windows version and build
   - PowerShell version
   - Installed dependencies status
   - Available disk space

4. **Contact Channels**:
   - Create issue on GitHub repository
   - Include all collected information
   - Be specific about the problem

### Prevention Tips

To avoid future issues:

1. **Regular Maintenance**:
   - Keep CLI Tool updated
   - Run `check` command periodically
   - Clean up old log files

2. **System Health**:
   - Maintain adequate disk space
   - Keep Windows updated
   - Regular antivirus scans

3. **Backup Strategy**:
   - Export game lists regularly
   - Backup settings folder
   - Document custom configurations

4. **Best Practices**:
   - Don't modify game folders manually
   - Use CLI Tool commands for management
   - Monitor system resources during large downloads

## Error Code Reference

### Common Error Patterns

| Error Pattern | Likely Cause | Quick Fix |
|---------------|--------------|-----------|
| "Python not found" | Python not installed | `install python` |
| "7-Zip not found" | 7-Zip missing | `install 7zip` |
| "Missing critical dependencies" | Setup incomplete | `check` then install missing |
| "Setup command required" | Configuration needed | `setup` |
| "Not logged in" | Authentication issue | `logout` then re-login |
| "Connection timeout" | Network issue | Check internet connection |
| "Access denied" | Permissions issue | Run as administrator |
| "Disk space" | Storage full | Free up disk space |

### Exit Codes

The CLI Tool uses these exit codes:
- **0**: Success
- **1**: General error
- **2**: Authentication failure
- **3**: Network error
- **4**: File system error
- **5**: Configuration error

These codes can be useful for scripting and automation. First Steps for Any Issue
1. **Check Dependencies**
   ```
   CCLS>check
   ```
   This reveals most common problems.

2. **View Recent Logs**
   ```
   CCLS>log list -3
   ```
   Check recent session logs for errors.

3. **Verify System Status**
   ```
   CCLS>sys cache status
   CCLS>version
   ```

4. **Test Basic Functionality**
   ```
   CCLS>help
   CCLS>list all
   ```

### Common Error Patterns
- **"Missing critical dependencies"** → Install required components
- **"Setup command required"** → Run initial setup
- **"Not logged in"** → Authentication issue
- **"Python not found"** → Python installation problem
- **"7-Zip not found"** → Extraction tool missing

## Installation Issues

### PowerShell Execution Policy Errors

**Problem**: Script won't run, shows execution policy error
```
File cannot be loaded because running scripts is disabled on this system
```

**Solutions**:
1. **Run as Administrator** and execute:
   ```powershell
   Set-ExecutionPolicy RemoteSigned -Scope CurrentUser
   ```
2. **Alternative method**:
   ```powershell
   Set-ExecutionPolicy Bypass -Scope Process -Force
   ```
3. **Per-session bypass**:
   ```powershell
   PowerShell -ExecutionPolicy Bypass -File "CLI.ps1"
   ```

### Windows Security Warning Loop

**Problem**: Security warning appears every time script runs

**Solution**:
1. When security dialog appears, **uncheck** "Always ask before opening this file"
2. Click "Open"
3. If problem persists, right-click script → Properties → Unblock

### Script Doesn't Start

**Problem**: Nothing happens when running the script

**Causes and Solutions**:
1. **PowerShell Version**: Ensure PowerShell 5.1+
   ```powershell
   $PSVersionTable.PSVersion
   ```
2. **File Association**: Use "Run with PowerShell" instead of double-click
3. **Antivirus Blocking**: Add script to antivirus exclusions
4. **Corrupted Download**: Re-download CLI.ps1

## Login and Authentication

### Invalid Credentials

**Problem**: "Username not found" or "Incorrect password"

**Solutions**:
1. **Verify Account**: Ensure account exists at https://games.ccls.icu
2. **Reset Password**: Use website password reset
3. **Check Typing**: Username and password are case-sensitive
4. **Account Issues**: Contact support via website

### Stored Credentials Not Working

**Problem**: Auto-login fails with saved credentials

**Solutions**:
1. **Clear and Re-enter**:
   ```
   CCLS>forget
   CCLS>logout
   ```
2. **Account Changes**: Password may have been changed
3. **System Changes**: Windows user profile changes can affect stored credentials

### Connection Timeout During Login

**Problem**: "Error connecting to server" during authentication

**Solutions**:
1. **Check Internet**: Verify connection to https://games.ccls.icu
2. **Firewall**: Ensure PowerShell can access internet
3. **Proxy Settings**: Configure if behind corporate proxy
4. **Try Later**: Server may be temporarily unavailable

### Developer Mode Access

**Problem**: Can't activate developer mode

**Solutions**:
1. **Correct Method**: Press Ctrl+Q at username prompt, then type "devmode"
2. **Alternative**: Use `devmode` command after login
3. **Clear Credentials**: Developer mode clears stored login data

## Download Problems

### Python Not Found

**Problem**: "Python not found" error during downloads

**Solutions**:
1. **Install Python**:
   ```
   CCLS>install python
   ```
2. **Restart CLI Tool** after Python installation
3. **Manual Installation**: Download from https://python.org
   - **Important**: Check "Add Python to PATH" during installation
4. **Verify Installation**:
   ```cmd
   python --version
   ```

### Requests Library Missing

**Problem**: Download fails with requests-related errors

**Solutions**:
1. **Install Requests**:
   ```
   CCLS>install requests
   ```
2. **If Install Fails**:
   ```cmd
   pip install requests
   ```
3. **Upgrade Pip**:
   ```cmd
   python -m pip install --upgrade pip
   ```

### Download Interruptions

**Problem**: Downloads stop or fail partway through

**Causes and Solutions**:
1. **Network Issues**: Check connection stability
2. **Disk Space**: Ensure sufficient space in temp directory
3. **Resume Support**: Restart download to resume from interruption
4. **Antivirus**: Add temp directory to exclusions

### Slow Download Speeds

**Problem**: Downloads are slower than expected

**Solutions**:
1. **Install All Dependencies**:
   ```
   CCLS>check
   ```
2. **Close Other Applications**: Free up bandwidth
3. **Check Network**: Run speed test
4. **Use Wired Connection**: More stable than WiFi

## Extraction and Installation

### 7-Zip Not Found

**Problem**: "7-Zip not found" error during extraction

**Solutions**:
1. **Install 7-Zip**:
   ```
   CCLS>install 7zip
   ```
2. **Manual Installation**: Download from https://7-zip.org
3. **Verify Installation**: Check if 7z.exe exists in expected locations

### Extraction Failures

**Problem**: Games download but fail to extract

**Causes and Solutions**:
1. **Corrupted Download**: Re-download the game
2. **Insufficient Space**: Check disk space in installation directory
3. **File Permissions**: Ensure write access to installation directory
4. **Antivirus Interference**: Temporarily disable real-time scanning

### Game Folder Conflicts

**Problem**: "Folder name conflict detected" during installation

**Solutions**:
1. **Accept Overwrite**: Choose 'Y' to replace existing folder
2. **Manual Cleanup**: Delete conflicting folder manually
3. **Rename Existing**: Move existing folder to different location

### Incomplete Installation

**Problem**: Game installs but seems incomplete or corrupted

**Solutions**:
1. **Re-download**: Delete partial installation and download again
2. **Check Logs**: Use `log list` to find detailed error information
3. **Verify Space**: Ensure sufficient disk space
4. **Test Different Game**: Verify if issue is game-specific

## Performance Issues

### Slow Response Times

**Problem**: CLI Tool responds slowly to commands

**Causes and Solutions**:
1. **Large Game Library**: Use cache refresh
   ```
   CCLS>sys cache refresh
   ```
2. **Disk Performance**: Move installation to faster drive
3. **Memory Usage**: Restart CLI Tool periodically
4. **System Resources**: Close other applications

### High Memory Usage

**Problem**: PowerShell process uses excessive memory

**Solutions**:
1. **Restart Session**: Exit and restart CLI Tool
2. **Cache Issues**: Refresh library cache
3. **Log Cleanup**: Remove old log files
4. **System Restart**: Reboot computer if needed

### Browse Mode Slow Loading

**Problem**: Browse command takes long time to load

**Solutions**:
1. **Cache Rebuild**:
   ```
   CCLS>sys cache refresh
   ```
2. **Large Library**: Expected with many games (cache helps)
3. **Disk Issues**: Check disk health and space

## System Compatibility

### Windows Version Issues

**Problem**: Script doesn't work on older Windows versions

**Requirements**:
- **Minimum**: Windows 10 build 1903
- **Recommended**: Windows 10/11 with latest updates
- **PowerShell**: Version 5.1 or later

### PowerShell Version Compatibility

**Problem**: Features don't work as expected

**Check Version**:
```powershell
$PSVersionTable.PSVersion
```

**Solutions**:
1. **Update Windows**: Get latest PowerShell version
2. **Manual Update**: Install PowerShell 7+ from Microsoft
3. **Compatibility Mode**: Some features may be limited on older versions

### Architecture Issues

**Problem**: Python installation fails on specific architectures

**Solutions**:
1. **Use CLI Tool Installer**: Automatically detects architecture
2. **Manual Download**: Get correct Python version for your system
   - 64-bit Windows: Use 64-bit Python
   - 32-bit Windows: Use 32-bit Python

## Network and Connectivity

### Cannot Connect to Server

**Problem**: "Error connecting to server" messages

**Diagnostic Steps**:
1. **Test Website**: Visit https://games.ccls.icu in browser
2. **DNS Check**: Ensure domain resolves correctly
3. **Firewall**: Check Windows Firewall settings
4. **Antivirus**: Verify not blocking connections

### SSL/TLS Certificate Errors

**Problem**: Certificate validation failures

**Solutions**:
1. **Update Windows**: Install latest security updates
2. **Certificate Store**: Update Windows certificate store
3. **Time/Date**: Ensure system clock is correct

### Proxy Configuration

**Problem**: CLI Tool doesn't work behind corporate proxy

**Solutions**:
1. **PowerShell Proxy**: Configure PowerShell proxy settings
2. **System Proxy**: Use Windows proxy settings
3. **Direct Connection**: Test from non-proxy environment

## Cache and Data Issues

### Corrupted Library Cache

**Problem**: Browse mode shows incorrect information

**Solutions**:
1. **Refresh Cache**:
   ```
   CCLS>sys cache refresh
   ```
2. **Delete Cache File**: Remove `settings/lib.json` and restart
3. **Check Disk**: Verify installation directory integrity

### Settings File Corruption

**Problem**: CLI Tool can't load settings

**Solutions**:
1. **Delete Settings**: Remove `settings/settings.json`
2. **Run Setup**: Reconfigure using `setup` command
3. **Backup Restore**: Restore from backup if available

### Log File Issues

**Problem**: Cannot access or view log files

**Solutions**:
1. **Permissions**: Check file permissions in logs folder
2. **File Locks**: Ensure no other applications have files open
3. **Disk Space**: Verify sufficient space for log operations

## Advanced Troubleshooting

### Memory Dump Analysis

For persistent crashes:
1. **Enable Debugging**: Modify script to enable detailed logging
2. **Collect Information**:
   - PowerShell version
   - Windows version
   - Installed dependencies
   - Error messages
   - Log files

### Registry Issues

If execution policy changes don't persist:
1. **Check Group Policy**: Verify no conflicting policies
2. **Registry Backup**: Create backup before changes
3. **Manual Registry Edit**: Modify PowerShell execution policy in registry

### Environment Variables

Check environment variables affecting PowerShell:
```powershell
Get-ChildItem Env:
```

Key variables:
- `PSExecutionPolicyPreference`
- `PSModulePath`
- `PATH`

### Antivirus Deep Scan

If persistent issues occur:
1. **Exclude Directories**:
   - CLI Tool directory
   - Installation directory
   - Temp directory
2. **Whitelist Process**: Add PowerShell.exe to exclusions
3. **Disable Real-time**: Temporarily for testing

###