# User Guide

This comprehensive guide covers how to use the CCLS Games CLI Tool effectively, from basic operations to advanced features.

## Table of Contents

1. [Getting Started](#getting-started)
2. [Basic Workflow](#basic-workflow)
3. [Game Discovery](#game-discovery)
4. [Downloading Games](#downloading-games)
5. [Managing Installed Games](#managing-installed-games)
6. [Interactive Browse Mode](#interactive-browse-mode)
7. [Library Cache System](#library-cache-system)
8. [Logging and Session Management](#logging-and-session-management)
9. [Startup Messages](#startup-messages)
10. [Developer Mode](#developer-mode)
11. [Advanced Features](#advanced-features)

## Getting Started

### First Launch
After installation, when you first run the CLI Tool:

1. **Login Process**: Enter your CCLS Games credentials
2. **Setup Configuration**: Run `setup` to configure directories
3. **Dependency Check**: Run `check` to verify all components are installed
4. **Ready to Use**: Start exploring games with `search library`

### Understanding the Interface
The CLI Tool uses a command-line interface with the prompt:
```
CCLS>
```

Commands are entered after this prompt. The tool provides extensive help:
- `help` - Basic help overview
- `help -a` - Complete command reference
- `[command] help` - Specific command help

## Basic Workflow

### Typical Session Flow
1. **Start the CLI Tool**
   ```
   Right-click CLI.ps1 → Run with PowerShell
   ```

2. **Browse Available Games**
   ```
   CCLS>search library
   ```

3. **Download a Game**
   ```
   CCLS>get cg0025
   ```

4. **Manage Installed Games**
   ```
   CCLS>browse
   ```

5. **Exit**
   ```
   CCLS>exit
   ```

### Key Concepts

#### Game IDs
- **Games**: Use format `cg0000` (e.g., cg0025)
- **Bundles**: Use format `cb0000` (e.g., cb0010)
- IDs are unique identifiers for each game/bundle

#### File Organization
- Games are installed in your configured installation directory
- Each game gets its own folder
- Metadata is stored in `[GameID].json` files

## Game Discovery

### Browsing the Library
```
CCLS>search library
```
This displays all available games and bundles in a formatted list showing:
- Game/Bundle name
- Unique ID (cg0000 or cb0000)
- Organized by type (games vs bundles)

### Searching by Name
```
CCLS>search game [search term]
```
Examples:
```
CCLS>search game tekken
CCLS>search game assassin
CCLS>search game call of duty
```

This provides:
- Fuzzy matching (finds partial matches)
- Ranked results (exact matches first)
- Interactive selection menu
- Option to download directly from search results

### Getting Game Information
```
CCLS>search [game_id]
```
Example:
```
CCLS>search cg0025
```

Displays detailed information:
- Game description
- System requirements
- Safety information
- Version details
- File sizes
- Platform availability

## Downloading Games

### Basic Download
```
CCLS>get [game_id]
```
Example:
```
CCLS>get cg0025
```

### Download by Name
```
CCLS>get game [game_name]
```
Example:
```
CCLS>get game tekken 8
```

### Skip Confirmation
```
CCLS>get [game_id] -y
CCLS>get game [game_name] -y
```

### Download Process
1. **Validation**: Checks game ID and availability
2. **Confirmation**: Shows game info and asks for confirmation
3. **Download**: High-speed download with progress tracking
4. **Extraction**: Automatic extraction using 7-Zip
5. **Metadata**: Saves game information for future management

### Download Features
- **Resume Support**: Downloads can be resumed if interrupted
- **Progress Tracking**: Real-time download progress and speed
- **Cancellation**: Press Ctrl+Z to cancel downloads
- **Conflict Resolution**: Handles existing installations intelligently

### Direct Download from Search
When using `search game [term]`, you can download directly:
```
CCLS>search game tekken
[Results shown]
Selection: get 2
```

## Managing Installed Games

### List All Games
```
CCLS>list all           # Basic list
CCLS>list all -d        # Detailed view with versions and sizes
```

### Get Game Information
```
CCLS>list [folder_name]              # Basic info
CCLS>list [folder_name] -d           # Detailed info
CCLS>list [folder_name] -tree        # File tree view
CCLS>list [folder_name] -tree -d     # Detailed info + file tree
```

### Alternative Identification Methods
```
CCLS>list [game_id]                  # By game ID
CCLS>list game [game_name]           # By game name
CCLS>list gamedir [folder_name]      # By folder name (explicit)
```

### Delete Games
```
CCLS>del [folder_name]               # With confirmation
CCLS>del [folder_name] -y            # Skip confirmation
CCLS>del [game_id]                   # By game ID
CCLS>del game [game_name]            # By game name
```

## Interactive Browse Mode

### Starting Browse Mode
```
CCLS>browse
```

### Browse Interface
The browse mode displays:
- **Game List**: All installed games with numbers
- **Game Details**: Name, ID, size, version, type
- **Color Coding**: 
  - Green: Official CCLS games with metadata
  - Gray: Manual installations without metadata
  - Red: Outdated versions

### Browse Commands
- **View Game**: `view [number]` or just `[number]`
- **Delete Game**: `del [number]`
- **Update Game**: `update [number]`
- **Refresh Info**: `refresh [number]`
- **Exit**: Press Enter

### Browse Features
- **Fast Loading**: Uses local cache for instant display
- **Online Checks**: Only connects when checking for updates
- **Update Detection**: Shows which games have newer versions
- **Detailed Information**: Full game details including system requirements

## Library Cache System

### What is the Cache?
The CLI Tool maintains a local cache (`lib.json`) that stores:
- Game folder information
- File sizes and metadata
- Version information
- Installation status

### Cache Benefits
- **Fast Loading**: Browse mode loads instantly
- **Offline Functionality**: View installed games without internet
- **Efficient Updates**: Only checks online when requested

### Cache Management
```
CCLS>sys cache status      # View cache information
CCLS>sys cache refresh     # Manually rebuild cache
```

### When Cache Updates
- Automatically after game installation/deletion
- When cache becomes invalid or corrupted
- Manually via refresh command

## Logging and Session Management

### Session Logs
Every CLI Tool session creates a log file in the `logs/` folder:
- Timestamped filename
- Complete session history
- Error tracking
- Performance metrics

### Log Management
```
CCLS>log list                        # Browse all logs
CCLS>log list -5                     # Show 5 newest logs
CCLS>log view [filename]             # View log contents
CCLS>log del [filename]              # Delete a log
CCLS>log open [filename]             # Open with default editor
```

### Log Browser
The log browser provides:
- Interactive file selection
- File size and date information
- Color-coded file age
- Bulk operations

## Startup Messages

### What are Startup Messages?
Customizable welcome screens that appear after login, featuring:
- Colorful formatted text
- Game library statistics
- Custom templates
- Dynamic content

### Managing Startup Messages
```
CCLS>sys start-message list                 # Available templates
CCLS>sys start-message get [template]       # Download template
CCLS>sys start-message enable [template]    # Enable template
CCLS>sys start-message get,enable [template] # Download and enable
CCLS>sys start-message try [template]       # Preview template
CCLS>sys start-message view                 # View current message
CCLS>sys start-message default              # Disable custom messages
```

### Template Types
- **Static**: Fixed text with colors
- **Dynamic**: Display current game statistics
- **Interactive**: Custom layouts and formatting

## Developer Mode

### What is Developer Mode?
A special mode for testing and development that:
- Skips login requirements
- Disables online API calls
- Provides local-only functionality
- Useful for testing and development

### Activating Developer Mode
1. **During Login**: Press Ctrl+Q and type "devmode"
2. **From CLI**: `devmode` command toggles the mode

### Developer Mode Features
- No login required
- All local commands work
- Online commands (`get`, `search`) are disabled
- Cache and log systems remain functional

### Exiting Developer Mode
```
CCLS>devmode
```
This toggles back to normal mode and clears stored credentials.

## Advanced Features

### Version Management
```
CCLS>version                 # Check current version
CCLS>update                  # Update CLI Tool
CCLS>changelog [version]     # View version changes
CCLS>changelog latest        # Latest version changes
```

### System Utilities
```
CCLS>check                   # System requirements check
CCLS>setup                   # Reconfigure directories
CCLS>install [utility]       # Install dependencies
CCLS>clear                   # Clear console
```

### Credential Management
```
CCLS>logout                  # Log out and re-login
CCLS>forget                  # Remove stored credentials
```

### Performance Optimization
- **Cache System**: Fast local operations
- **Background Updates**: Non-blocking online checks
- **Parallel Processing**: Efficient file operations
- **Memory Management**: Optimized for long sessions

### Safety Features
- **Confirmation Prompts**: Prevent accidental deletions
- **Backup Creation**: Automatic backups during updates
- **Error Recovery**: Graceful handling of failures
- **Resume Support**: Recover from interrupted operations

## Tips and Best Practices

### Efficient Workflow
1. Use `browse` for regular game management
2. Use `search game [name]` when you know what you want
3. Enable login saving for convenience
4. Regular cache refresh for large libraries

### Storage Management
- Monitor disk space before large downloads
- Use separate drives for games and temp files
- Regular cleanup of old log files
- Consider SSD for installation directory

### Performance Tips
- Close other applications during large downloads
- Use `-y` flag for batch operations
- Enable all dependencies for best performance
- Regular system restarts for optimal performance

### Security Considerations
- Only download from trusted sources
- Keep CLI Tool updated
- Regular credential rotation
- Monitor log files for suspicious activity

## Next Steps

- Review [Commands Reference](commands.md) for complete command details
- Check [Configuration Guide](configuration.md) for advanced settings
- See [Troubleshooting Guide](troubleshooting.md) for common issues