Overview
--------
Version 1.1.6 focuses on improving the game download functionality with enhanced
detection of existing installations and better handling of file replacements, 
providing a smoother and more reliable download experience.

Key Changes
----------
- Enhanced Game Download System
  * Added detection of existing game installations during download
  * Implemented confirmation prompt for replacing existing game files
  * Improved cleanup of outdated installation folders during upgrades
  * Better handling of folder names with special characters

- Improved User Experience
  * Added warning when downloading a game that already exists
  * Clear messaging when replacing existing game installations
  * More detailed progress information during replacement process
  * Automatic detection of game IDs in existing folders

- File Management Improvements
  * Added ability to recognize games by ID in filenames
  * Improved handling of folder structures during extraction
  * Better cleanup of temporary files after successful downloads
  * Enhanced folder size calculation for replacement decisions

- Bug Fixes
  * Fixed issue where existing installations would create duplicate folders
  * Resolved problems with special characters in game folder names
  * Fixed incomplete cleanup of temporary files in some scenarios
  * Addressed edge cases where game metadata was not properly saved

- Miscellaneous
  * Updated version number to 1.1.6
  * Minor performance improvements for download and extraction processes
  * Enhanced logging details for download and installation processes
  * Code refactoring for better maintainability

This update significantly improves the reliability of game downloading and installation, particularly for
users who frequently update their games or need to re-download content. The enhanced detection of existing
installations helps prevent duplicate downloads and ensures clean upgrades when newer versions become available.