Overview (V2.0 FIRST OFFICIAL RELEASE) 
--------
Version 2.0.0 introduces a modernized API infrastructure with enhanced professional presentation 
and critical script management improvements. This update addresses a fundamental issue with the 
update functionality while transitioning to a more robust and scalable API endpoint structure 
for improved reliability and future development.

Key Changes
-----------

Enhanced API Infrastructure
* NEW: Migrated to professional v2.0 API endpoint structure
* Updated all API calls to use new "https://games.ccls.icu/CLI/api/2.0" base URL
* Improved API organization with dedicated endpoints for better maintainability
* Enhanced User-Agent headers updated to "CCLS-CLI/2.0" for proper identification
* Modernized endpoint paths for utilities, changelogs, and version management

Critical Script Management
* NEW: Automatic script filename validation and correction on startup
* Implemented Test-ScriptNaming function to ensure proper CLI.ps1 naming
* Automatic detection and renaming of incorrectly named script files
* Intelligent backup creation for existing CLI.ps1 files before renaming
* Enhanced logging for script naming operations and conflict resolution
* Fixed critical issue where update functionality failed with non-standard script names

Update System Improvements
* Resolved update command failures caused by incorrect script naming
* Enhanced update reliability through proper script file management
* Improved backup system for script updates with timestamp preservation
* Better error handling during update processes with automatic cleanup
* Streamlined update workflow with consistent file naming requirements

System Reliability Enhancements
* Enhanced startup sequence with comprehensive script validation
* Improved error handling for script management operations
* Better logging and debugging capabilities for troubleshooting
* Automated conflict resolution for script naming issues
* Enhanced file management with proper cleanup procedures

API Endpoint Modernization
* Updated utility installation endpoints to v2.0 structure
* Modernized changelog retrieval with new API paths
* Enhanced version checking with professional endpoint organization
* Improved download URLs for utilities and updates
* Standardized API response handling across all endpoints

Backward Compatibility
* Maintained full compatibility with existing user settings and configurations
* Preserved all existing functionality while upgrading underlying infrastructure
* Seamless migration from v1.x API endpoints to v2.0 structure
* No impact on user workflows or stored credentials
* Continued support for all existing commands and features

Version Management
* Updated version number to 2.0.0 across all system components
* Enhanced version tracking and update notification system
* Improved changelog management with new API structure
* Better version comparison and update availability detection

This release establishes a solid foundation for future development while ensuring the critical 
update functionality works reliably regardless of how users have named their script files. 
The modernized API infrastructure provides better performance and maintainability for ongoing 
enhancements.