## [1.1.14] - 2025-09-17

### Added

- **X-Accel-Redirect Support**: Revolutionary download system for nginx-based deployments
  - nginx handles file transfers directly after PHP authorization
  - Eliminates PHP memory limitations for large file downloads
  - Enables enterprise-grade download performance with minimal resource usage
- **Download Resume Capability**: HTTP range request support for interrupted downloads
  - Clients can resume downloads from breakpoint instead of restarting
  - Automatic range header processing and partial content responses
  - Enhanced reliability for large file transfers over unstable connections
- **Optimized PHP Streaming**: Fallback streaming system for non-nginx environments
  - Chunked file delivery (8KB chunks) to prevent memory exhaustion
  - Connection abort detection to stop streaming when client disconnects
  - Memory-efficient file handling for deployments without X-Accel-Redirect

### Enhanced

- **Docker Download Performance**: Resolved file type-specific download failures
  - Fixed MIME type handling for problematic extensions (.7z, .mp4, .webp)
  - Enhanced nginx configuration with proper buffering controls
  - Eliminated restrictive location blocks that interfered with downloads
- **Large File Handling**: Dramatically improved support for multi-gigabyte downloads
  - Increased PHP execution timeout to 7200 seconds (2 hours)
  - Expanded client body size limits to 200GB for large operations
  - Disabled output buffering for download operations
- **nginx Configuration**: Comprehensive optimization for file serving
  - Extended fastcgi timeouts for large file processing
  - Conditional security headers (bypassed for downloads)
  - Internal location blocks for secure direct file access
  - Sendfile optimization with 1MB chunk sizes

### Fixed

- **Docker-Specific Issues**: Resolved selective file type download failures
  - Corrected nginx MIME type configuration for binary files
  - Removed overly restrictive access patterns
  - Fixed PHP-FPM timeout handling for download operations
- **Memory Limitations**: Eliminated PHP memory constraints on large downloads
  - Downloads no longer load entire files into PHP memory
  - Streaming approach prevents out-of-memory errors
  - Scalable to files of unlimited size (tested with 60GB+ files)
- **Download Reliability**: Enhanced error handling and recovery
  - Proper HTTP status codes for partial content and errors
  - Graceful handling of client disconnections during transfers
  - Improved validation of file access permissions before streaming

### Performance

- **File Transfer Speed**: Significant improvement in download performance
  - nginx direct file serving bypasses PHP processing overhead
  - Optimized buffer sizes and TCP settings for large transfers
  - Comparable performance to dedicated file hosting services
- **Resource Efficiency**: Reduced server resource consumption
  - Minimal PHP memory usage regardless of file size
  - Lower CPU utilization during file transfers
  - Better concurrent download handling capacity
- **Network Optimization**: Enhanced data transfer protocols
  - TCP no-push and no-delay optimizations for large files
  - Proper cache control headers for download vs static content
  - Range request support reduces bandwidth waste on failed downloads

### Security

- **Access Control Preservation**: Maintained security while improving performance
  - PHP continues to handle all authorization checks
  - File access permissions enforced before nginx handoff
  - Internal nginx locations prevent direct file access bypass
- **Enhanced Validation**: Stricter file access verification
  - Path traversal protection maintained in optimized code paths
  - Extension-based access control preserved
  - Deny/allow list enforcement before file serving

### Configuration

- **Docker Environment**: Updated container configuration for optimal performance
  - Enhanced nginx.conf with X-Accel-Redirect support
  - Optimized PHP-FPM settings for large file operations
  - Internal file serving location blocks for secure access
- **Script Installation**: Updated nginx template for bare-metal deployments
  - X-Accel-Redirect support added to install script template
  - Consistent performance benefits across deployment methods
  - Backward compatibility with existing installations