## [1.1.15] - 2025-09-18

### Added

- **Default Favicon Support**: Comprehensive favicon system for enhanced user experience
  - Multi-size favicon support (16x16, 32x32, 48x48, 96x96, 144x144, 192x192, 180x180, icon.ico)
  - Works seamlessly with both API-enabled and API-disabled modes
  - Automatic favicon downloading and local caching when API is disabled
  - Apple touch icon support for mobile devices and PWA installations
- **Access URL Configuration**: Custom domain support for reverse proxy deployments
  - New `access_url` parameter in config.json for override URL generation
  - Format: `"https://example.com:8443"` - includes protocol and optional port
  - Resolves incorrect share URLs behind load balancers and reverse proxies
  - Maintains backward compatibility with automatic URL detection when unset
- **100 New File Type Extensions**: Massive expansion of supported file formats
  - Security and penetration testing tools (26 extensions)
  - Web browsers and HTTP clients (22 extensions)
  - Content management systems and e-commerce platforms (19 extensions)
  - Documentation generators and static site builders (12 extensions)
  - Testing frameworks and automation tools (14 extensions)
  - Modern web frameworks and development tools (7 extensions)

### Enhanced

- **Icon System Improvements**: Expanded visual file type identification
  - Custom icons for all 100 new file extensions
  - Enhanced icon fallback system for missing or corrupted icons
  - Improved local icon caching and management
  - Better icon mapping for specialized development tools
- **Configuration Management**: Robust handling of version updates and migrations
  - Enhanced config merging process preserves user customizations
  - Automatic backup creation before configuration updates
  - Improved error handling for invalid or corrupted configurations
  - Better validation for new configuration parameters
- **Resource Management**: Optimized handling of local vs remote resources
  - Intelligent resource caching for offline-first deployments
  - Enhanced local resource validation and integrity checking
  - Improved fallback mechanisms when API resources are unavailable
  - Better cleanup routines for temporary and cached files

### Fixed

- **Favicon Display Issues**: Resolved inconsistent favicon loading
  - Fixed favicon display problems in API-disabled mode
  - Corrected path resolution for favicon files in subdirectory installations
  - Enhanced favicon caching to prevent loading failures
  - Improved favicon fallback when custom icons are unavailable
- **URL Generation Problems**: Corrected share link generation behind proxies
  - Fixed incorrect absolute URLs when access_url is not configured
  - Resolved protocol detection issues in complex proxy setups
  - Enhanced URL generation for subdirectory installations
  - Improved handling of non-standard ports in generated URLs
- **File Type Detection**: Enhanced accuracy of extension-based file recognition
  - Corrected mapping for ambiguous file extensions
  - Improved handling of case-sensitive file systems
  - Better detection of files with multiple extensions
  - Enhanced support for specialized development file formats

### Performance

- **Local Resource Optimization**: Faster loading for offline deployments
  - Optimized favicon loading and caching mechanisms
  - Reduced redundant API calls through better caching strategies
  - Improved local file validation to prevent unnecessary downloads
  - Enhanced resource compression for locally cached files
- **Configuration Processing**: Streamlined config update and validation
  - Faster configuration file parsing and validation
  - Optimized extension mapping lookups for large file directories
  - Reduced memory usage during configuration processing
  - Better caching of frequently accessed configuration values
- **Icon Loading Performance**: Accelerated visual element rendering
  - Improved icon caching reduces repeated file system operations
  - Optimized icon path resolution for faster page rendering
  - Better icon preloading for commonly accessed file types
  - Enhanced sprite-based icon loading for supported browsers

### Security

- **Configuration Validation**: Enhanced security for configuration parameters
  - Strict validation of access_url parameter to prevent injection attacks
  - Enhanced path validation for local resource access
  - Improved sanitization of user-configurable URL components
  - Better error handling to prevent information disclosure
- **Resource Access Control**: Maintained security while adding features
  - All new file types respect existing access control mechanisms
  - Enhanced validation for local resource file access
  - Improved path traversal protection for cached resources
  - Stricter permissions on generated configuration backups

### Configuration

- **New Parameters**: Extended configuration options for advanced deployments
  - `access_url`: Custom base URL for share link generation
  - Enhanced favicon configuration options
  - Improved local resource management settings
  - Better integration with existing configuration validation
- **Migration Support**: Seamless upgrade path from previous versions
  - Automatic detection and migration of deprecated settings
  - Preserve existing customizations during version updates
  - Enhanced backup and rollback capabilities for configuration changes
  - Better logging of configuration update processes

### File Type Support

**Security & Penetration Testing (26)**
- .aircrack, .amass, .burp, .censys, .dirb, .dnsrecon, .ffuf, .fierce
- .gobuster, .hashcat, .hydra, .john, .maltego, .massdns, .metasploit
- .nessus, .nikto, .nmap, .shodan, .sqlmap, .subfinder, .sublist3r
- .tcpdump, .theharvester, .wireshark, .zap

**Web Browsers & HTTP Clients (22)**
- .brave, .charles, .chrome, .curl, .edge, .fiddler, .firefox, .headless
- .httpie, .ie, .insomnia, .lynx, .opera, .paw, .phantom, .postman
- .safari, .slimerjs, .tor, .vivaldi, .w3m, .wget

**CMS & E-commerce Platforms (19)**
- .concrete5, .craft, .drupal, .ghost, .joomla, .kirby, .magento, .modx
- .opencart, .oscommerce, .oxid, .prestashop, .shopify, .statamic, .strapi
- .textpattern, .typo3, .woocommerce, .wordpress, .zencart

**Documentation & Static Sites (12)**
- .docusaurus, .doxygen, .gitbook, .hexo, .hugo, .jekyll, .jsdoc, .mkdocs
- .sphinx, .storybook, .typedoc, .vuepress

**Testing & Automation (14)**
- .backstop, .casper, .chromatic, .gemini, .hermione, .looks-same
- .nightwatch, .percy, .pixelmatch, .protractor, .resemblejs, .testcafe
- .webdriverio, .wraith

**Modern Web Frameworks (7)**
- .blitz, .gridsome, .grav, .redwood, .remix, .differ