## [1.1.16] - 2025-09-23

### Added

- **Markdown Rendering Support**: Native markdown formatting for enhanced documentation viewing
  - Full GitHub-flavored markdown support for `.md` and `.markdown` files
  - Dark theme styling matching the indexer's aesthetic with proper contrast and readability
  - Comprehensive formatting support: headers, lists, code blocks, links, tables, blockquotes, and horizontal rules
  - Inline formatting: bold, italic, strikethrough, and inline code with syntax highlighting
  - Interactive "View Raw" toggle button allowing users to switch between formatted and plain text views
  - Custom CSS styling with proper spacing, typography, and visual hierarchy
  - Support for nested lists, complex tables, and multi-line code blocks with language detection
- **Non-Descript File Configuration**: Granular control over files without extensions
  - New `index_non-descript-files` setting to control indexing of extension-less files
  - New `view_non-descript-files` setting to control browser viewing of extension-less files
  - Enhanced file type detection for better handling of configuration files and scripts
  - Improved security through selective indexing of potentially sensitive system files
- **Raw Viewer Favicon Integration**: Complete favicon support across all viewing modes
  - Fixed missing favicon issue when viewing files with `?view=raw` parameter
  - Consistent branding and visual identity across directory listing and file viewing
  - Proper favicon caching and loading for improved performance
  - Support for all favicon sizes and formats in raw viewing mode

### Enhanced

- **Icon System Consistency**: Unified fallback behavior across all icon modes
  - Standardized "default" icon mode to use `non-descript-default-file.png` for unsupported extensions
  - Aligned behavior between "default" and "minimal" icon modes for consistency
  - Improved icon fallback logic for files without extensions or unknown file types
  - Enhanced visual consistency across different file type representations
- **File Type Detection**: Improved accuracy for extension-less and ambiguous files
  - Better handling of configuration files, shell scripts, and system files without extensions
  - Enhanced detection logic for files with multiple dots or complex naming patterns
  - Improved classification of makefiles, dockerfiles, and other development artifacts
  - More accurate MIME type detection for proper browser handling
- **Raw Viewer Infrastructure**: Robust foundation for file content display
  - Enhanced security validation for viewed files to prevent XSS and injection attacks
  - Improved content type detection and header management
  - Better error handling for corrupted or inaccessible files
  - Optimized file streaming for large documents and media files

### Fixed

- **Icon Display Inconsistencies**: Resolved visual discrepancies across icon modes
  - Fixed "default" mode showing different icons than "minimal" mode for the same file types
  - Corrected icon selection logic for files without clear type associations
  - Resolved icon caching issues that caused inconsistent displays after configuration changes
  - Improved icon loading fallbacks when custom icons are unavailable or corrupted
- **Markdown Parser Robustness**: Comprehensive parsing engine with proper content isolation
  - Fixed code blocks being incorrectly processed as markdown (preventing YAML lists in code)
  - Resolved placeholder replacement failures that caused malformed output
  - Corrected inline code formatting conflicts with bold/italic processing
  - Eliminated markdown processing interference with code content through isolation system
  - Fixed nested formatting issues and improved handling of complex markdown structures
- **Raw Viewer Branding**: Complete visual integration with main indexer interface
  - Corrected missing favicon elements in file viewing mode
  - Fixed inconsistent styling between directory listing and file viewing
  - Resolved header management issues that prevented proper favicon loading
  - Improved visual continuity across all indexer interfaces

### Performance

- **Markdown Processing Optimization**: Efficient parsing with minimal overhead
  - Implemented placeholder-based content isolation system (`XCODEBLOCKREPLACEX`) for faster processing
  - Optimized regex patterns for improved markdown parsing speed
  - Reduced memory usage through streaming markdown processing for large files
  - Enhanced caching of parsed markdown content for frequently accessed files
- **Icon Loading Efficiency**: Streamlined visual element rendering
  - Improved icon selection algorithm reduces file system operations
  - Better caching of icon path resolutions for faster page loads
  - Optimized fallback logic minimizes redundant icon lookups
  - Enhanced sprite-based loading where supported by browsers
- **File Viewer Performance**: Faster content delivery and rendering
  - Optimized file streaming for raw content viewing
  - Improved header management reduces browser rendering delays
  - Better content type detection prevents unnecessary processing
  - Enhanced caching strategies for frequently viewed file types

### Security

- **Content Display Protection**: Enhanced security for file viewing functionality
  - Strict validation of file paths prevents directory traversal attacks
  - Improved content sanitization for markdown rendering prevents XSS
  - Enhanced MIME type validation ensures safe content delivery
  - Better access control integration maintains existing security policies
- **Configuration Validation**: Robust handling of new configuration parameters
  - Strict validation of new non-descript file settings
  - Enhanced type checking for boolean configuration values
  - Improved error handling prevents configuration corruption
  - Better logging of configuration validation failures
- **File Access Control**: Maintained security while expanding functionality
  - All new file viewing features respect existing access control mechanisms
  - Enhanced validation for extension-less file access
  - Improved path sanitization for markdown content inclusion
  - Stricter permissions checking for sensitive file types

### Configuration

- **New Parameters**: Extended options for file handling and display
  - `index_non-descript-files`: Controls indexing of files without extensions (default: false)
  - `view_non-descript-files`: Controls browser viewing of extension-less files (default: false)
  - Enhanced integration with existing exclusion and viewable file systems
  - Backward compatibility maintained with existing configurations
- **File Type Integration**: Seamless incorporation with existing extension system
  - New settings automatically integrate with deny/allow list functionality
  - Proper inheritance of access control rules for extension-less files
  - Enhanced validation ensures configuration consistency
  - Improved error messages for configuration troubleshooting

### User Experience

- **Visual Consistency**: Unified interface across all indexer functions
  - Consistent favicon display throughout directory browsing and file viewing
  - Unified styling and theming across all interface elements
  - Improved visual hierarchy and readability in markdown content
  - Enhanced user navigation with clear mode switching controls
- **Content Accessibility**: Improved readability and usability
  - Dark theme markdown rendering reduces eye strain in low-light environments
  - Proper contrast ratios ensure accessibility compliance
  - Responsive design adapts to different screen sizes and devices
  - Clear visual indicators for different content modes and file types
- **Documentation Support**: Enhanced handling of project documentation
  - Native markdown rendering improves README file readability
  - Proper formatting of code examples and technical documentation
  - Support for complex documentation structures with nested content
  - Seamless switching between formatted and raw content views

### Technical Implementation

- **Markdown Parser Architecture**: Robust and extensible parsing system
  - Multi-stage processing pipeline with proper content isolation
  - Placeholder-based system protects code content from markdown processing
  - Extensible design allows for future markdown feature additions
  - Comprehensive error handling prevents parser failures from affecting page rendering
- **Icon Management System**: Unified handling across all display modes
  - Centralized icon selection logic reduces code duplication
  - Consistent fallback mechanisms across different icon modes
  - Improved error handling for missing or corrupted icon files
  - Enhanced debugging capabilities for icon-related issues
- **File Viewer Infrastructure**: Scalable foundation for content display
  - Modular design supports easy addition of new file type viewers
  - Proper separation of concerns between content delivery and presentation
  - Enhanced error handling provides better user feedback
  - Optimized resource management for improved server performance

### Backward Compatibility

- **Configuration Migration**: Seamless upgrade path
  - All existing configurations remain fully functional
  - New settings have sensible defaults that don't change existing behavior
  - Automatic detection and handling of legacy configuration formats
  - Clear migration path for users wanting to enable new features
- **API Compatibility**: Maintained integration with external systems
  - All existing URL patterns and parameters continue to work
  - New functionality adds to rather than replaces existing features
  - Proper versioning ensures stable integration points
  - Enhanced documentation for new API capabilities

This release significantly enhances the indexer's document viewing capabilities while maintaining the robust security and performance characteristics that users expect. The markdown rendering system provides a foundation for future enhancements to file content display, while the improved icon consistency and non-descript file handling offer better control over file system representation.