## [1.1.17] - 2025-09-25

### Major Architecture Changes

- **Complete API Independence**: Transformed from API-dependent to fully standalone operation
  - Eliminated all external API calls and automatic update mechanisms
  - Removed remote configuration fetching, icon downloads, and stylesheet retrieval
  - Removed version checking and auto-configuration systems for enhanced security and reliability
  - All resources now pre-installed in `.indexer_files/` directory for consistent performance
  - Enhanced deployment portability with no external dependencies or network requirements
- **Revolutionary URL Structure**: Complete restructuring from query parameters to clean, professional URLs
  - Transformed URLs from `index.php?path=folder&file=name&view=raw` to `domain.com/folder/filename?view=raw`
  - Implemented pure PHP URL router class with no server configuration dependencies
  - SEO-friendly URL structure improves search engine indexing and user experience
  - Professional appearance suitable for production environments and client-facing deployments
  - Maintained backward compatibility while providing modern URL conventions

### Enhanced View System

- **Comprehensive View Mode Restructuring**: Complete overhaul of file viewing and download options
  - **view=default**: New primary view mode with custom HTML wrapper and markdown formatting for `.md` files
  - **view=code**: Custom HTML wrapper displaying markdown files as plain text for code review
  - **view=markdown**: Dedicated markdown-only mode with auto-redirect for non-markdown files
  - **view=raw**: Redesigned to serve pure file content without HTML wrapper for direct file access
  - **No view parameter**: Defaults to new raw behavior for streamlined direct file serving
- **Dynamic View Controls**: Intelligent view mode switching based on file type and context
  - Context-aware view mode buttons that adapt to current file type and viewing mode
  - Enhanced "View Raw" buttons opening in new tabs with `target="_blank"` for better workflow
  - Seamless navigation between different view modes without losing file context
  - Improved user experience with intuitive mode transitions and clear visual indicators

### Content Processing Improvements

- **Enhanced Markdown Engine**: Robust parsing with improved code block handling
  - Fixed critical bug where markdown formatting would break for certain code block structures
  - Improved code block isolation preventing YAML lists and other code content from markdown processing
  - Enhanced nested formatting support for complex documentation structures
  - Better handling of inline code within markdown text to prevent formatting conflicts
  - Comprehensive placeholder system (`XCODEBLOCKREPLACEX`) ensures code content integrity
- **Improved File Type Detection**: More accurate classification and handling of diverse file types
  - Enhanced detection for files with multiple extensions or complex naming patterns
  - Better support for configuration files, shell scripts, and development artifacts
  - Improved MIME type detection for proper browser handling and security
  - More accurate classification of makefiles, dockerfiles, and system files

### Installation and Deployment

- **Streamlined Installation Process**: Enhanced `install.sh` script with complete resource management
  - Automated download and installation of all required files and directories
  - Complete `.indexer_files/` directory structure creation with proper permissions
  - Eliminated runtime file creation and directory setup from PHP code
  - Enhanced deployment consistency across different server environments
  - Pre-configured resource structure reduces first-run overhead and potential errors
- **Static Resource Architecture**: Optimized for reliable, consistent deployments
  - All stylesheets, icons, configurations, and mappings now pre-installed
  - Removed dynamic PHP processing for static assets improving performance
  - Enhanced security through elimination of runtime file system modifications
  - Simplified maintenance with centralized resource management
  - Better caching behavior with static resource delivery

### Technical Infrastructure

- **Pure PHP URL Router**: Robust routing system with comprehensive request handling
  - Server-agnostic routing implementation works across Apache, Nginx, and other web servers
  - Intelligent path parsing with proper security validation and sanitization
  - Enhanced folder and file operation routing with maintained access controls
  - Improved error handling for malformed URLs and invalid requests
  - Optimized performance through efficient route matching and parameter extraction
- **Resource Loading Optimization**: Streamlined asset delivery and management
  - Replaced dynamic PHP functions with static HTML links for faster page loads
  - Hardcoded paths to `.indexer_files/` directory eliminate runtime path resolution
  - Enhanced caching behavior with consistent resource URLs
  - Improved browser compatibility with standardized resource delivery
  - Reduced server load through elimination of dynamic resource generation

### Fixed

- **URL Generation Consistency**: Resolved various URL-related issues across the application
  - Fixed view mode buttons to use proper file URLs instead of script paths
  - Corrected double slash bug in parent directory navigation URLs (`//` to `/`)
  - Resolved folder download 502 gateway errors through improved routing logic
  - Fixed backward compatibility issues with existing `raw=1` parameter usage
  - Improved URL parameter parsing and generation throughout the application
- **Nginx Configuration Compatibility**: Enhanced server configuration support
  - Added proper location blocks for clean URL routing
  - Fixed access to `.indexer_files` directory while maintaining security for other hidden files
  - Enhanced security headers and proper request routing for all deployment scenarios
  - Improved Docker deployment configuration with updated location handling
  - Better support for subdirectory installations and reverse proxy setups

### Performance

- **Static Resource Delivery**: Optimized asset loading and reduced server overhead
  - Eliminated runtime PHP processing for stylesheets, icons, and configuration files
  - Pre-installed resources reduce file system operations and improve response times
  - Enhanced browser caching with consistent resource URLs and proper headers
  - Reduced memory usage through elimination of dynamic resource generation
  - Faster initial page loads with optimized asset delivery pipeline
- **URL Processing Efficiency**: Streamlined request handling and routing
  - Efficient URL parsing reduces processing overhead for each request
  - Optimized route matching algorithm improves response times
  - Better caching of parsed URLs and route decisions
  - Reduced server load through efficient request processing pipeline
  - Enhanced scalability with improved request handling architecture

### Security

- **Enhanced Access Control**: Strengthened security through improved validation
  - Strict path validation in URL router prevents directory traversal attacks
  - Enhanced file access controls maintained through new URL structure
  - Improved input sanitization for all URL parameters and routing decisions
  - Better protection against malformed requests and injection attempts
  - Maintained existing security policies while enhancing URL processing
- **Reduced Attack Surface**: Eliminated external dependencies and dynamic processing
  - Removal of API calls eliminates potential external attack vectors
  - Static resource architecture reduces runtime security risks
  - Enhanced validation for all file operations and resource access
  - Improved error handling prevents information disclosure
  - Better isolation between user requests and system operations

### Configuration

- **Deployment Standardization**: Consistent configuration across all installation types
  - Unified installation process through enhanced `install.sh` script
  - Standardized directory structure with proper permission handling
  - Consistent resource organization across different server environments
  - Improved configuration validation and error reporting
  - Enhanced documentation reflecting new installation requirements
- **Backward Compatibility**: Maintained existing functionality while adding new features
  - All existing configurations continue to function without modification
  - Legacy URL parameters supported alongside new clean URL structure
  - Existing access controls and security policies preserved
  - Smooth upgrade path for existing installations
  - Clear migration documentation for advanced customizations

### User Experience

- **Professional URL Structure**: Clean, readable URLs suitable for production environments
  - SEO-friendly URL format improves search engine indexing
  - Professional appearance appropriate for client-facing deployments
  - Improved sharing and bookmarking with meaningful URL paths
  - Better integration with external tools and documentation systems
  - Enhanced user experience with intuitive navigation structure
- **Enhanced File Viewing**: Comprehensive view modes with improved functionality
  - Context-aware view controls adapt to file types and user needs
  - Seamless switching between different viewing modes
  - Improved markdown rendering with better code block handling
  - Enhanced raw file serving for direct integration with external tools
  - Better support for various file types and viewing scenarios

### Documentation

- **Complete Documentation Overhaul**: Updated all documentation to reflect architectural changes
  - Comprehensive installation guide covering new `install.sh` requirements
  - Updated configuration documentation reflecting static resource architecture
  - Enhanced troubleshooting guides for new URL structure and routing
  - Improved deployment examples for various server configurations
  - Clear migration guides for existing installations

### Backward Compatibility

- **Seamless Upgrade Path**: Maintained compatibility while providing modern features
  - Legacy URL parameters continue to function alongside new clean URLs
  - Existing configurations and customizations remain fully operational
  - Automatic detection and handling of old URL formats
  - Clear migration path for users wanting to adopt new features
  - Comprehensive upgrade documentation with step-by-step instructions