## [1.1.19] - 2025-09-27

### Security

- **Process Manager Migration**: Complete migration from supervisor to s6-overlay
  - **BREAKING**: Removed supervisor completely due to multiple security vulnerabilities (CVE-2023-27482)
  - Implemented s6-overlay v3 as secure container-native process supervisor
  - Eliminated Python runtime dependency reducing attack surface by ~50MB
  - Enhanced container lifecycle management with proper PID 1 handling
  - Improved signal forwarding and zombie process reaping
  - Container now exits properly when services fail (better health reporting)
- **Docker Image Hardening**: Addressed additional security vulnerabilities
  - Replaced `unzip` with `p7zip` to eliminate CVE-2008-0888 vulnerability
  - Updated base Alpine Linux image to `alpine3.22` for latest security patches
  - Enhanced container security posture with minimal attack surface
  - Improved archive handling capabilities with more robust tooling

### Enhanced

- **Application Architecture**: Restructured core components for better maintainability
  - Moved `IndexerCache` class from main index.php to dedicated endpoint `.indexer_files/php/IndexerCache.php`
  - Relocated `URLRouter` class from main index.php to dedicated endpoint `.indexer_files/php/URLRouter.php`
  - Improved code organization with cleaner separation of concerns
  - Enhanced modularity for easier maintenance and debugging
- **Page Title Display**: Improved contextual title generation
  - Changed title format from full path display (`Index of /example/folder`) to simplified folder name (`folder`)
  - Added special handling for root folder indexing displaying "5q12 Indexer" as title
  - Enhanced user experience with cleaner, more focused page titles
  - Reduced visual clutter in browser tabs and bookmarks

### Fixed

- **URL Routing Consistency**: Resolved manual URL generation issues across interface components
  - Fixed "Close" button on share popups to use proper URL routing instead of manual generation
  - Corrected "options-menu" button URL handling for consistent navigation
  - Fixed all options in "options-dropdown" to utilize centralized URL routing system
  - Improved URL consistency and reduced potential for broken links

### Configuration

- **Docker Environment Integration**: Comprehensive configuration management through environment variables
  - Added support for `config.json` configuration via Docker Compose environment variables
  - New environment variable support includes:
    - `INDEXER_ACCESS_URL`: Set application base URL
    - `INDEXER_CACHE_TYPE`: Configure caching mechanism (json)
    - `INDEXER_ICON_TYPE`: Set icon display mode (minimal)
    - `INDEXER_DISABLE_FILE_DOWNLOADS`: Control file download functionality
    - `INDEXER_DISABLE_FOLDER_DOWNLOADS`: Control folder download functionality
    - `INDEXER_INDEX_HIDDEN`: Toggle hidden file indexing
    - `INDEXER_INDEX_ALL`: Enable comprehensive file indexing
    - `INDEXER_DENY_LIST`: Specify excluded paths and patterns
    - `INDEXER_ALLOW_LIST`: Specify included paths and patterns
    - `INDEXER_INDEX_FILETYPE_PHP`: Control PHP file indexing
    - `INDEXER_VIEW_FILETYPE_JS`: Enable JavaScript file viewing
    - `INDEXER_INDEX_FILETYPE_MD`: Control Markdown file indexing
    - `INDEXER_VIEW_FILETYPE_MD`: Enable Markdown file viewing
  - Enhanced Docker deployment flexibility with comprehensive configuration options
  - Simplified container orchestration with environment-based configuration

### Performance

- **S6-Overlay Process Management**: Optimized container startup and resource usage
  - Faster container startup compared to supervisor-based images
  - Reduced memory footprint with elimination of Python runtime
  - More efficient process supervision with C-based s6 implementation
  - Better resource utilization in containerized environments
- **PHP Endpoint Management**: Optimized file handling for containerized deployments
  - Enhanced initialization script with special handling for `.indexer_files/php/` directory
  - Automatic recreation of PHP files ensures up-to-date functionality across container restarts
  - Improved reliability of core application components in Docker environments
  - Reduced potential for stale file issues in containerized deployments

### Technical Implementation

- **S6-Overlay Service Architecture**: Modern container-native process supervision
  - Implemented dedicated s6 service definitions for nginx and php-fpm
  - Added comprehensive initialization service with enhanced configuration merging
  - Proper service dependency management ensuring correct startup order
  - Container-native signal handling and graceful shutdown procedures
- **URL Router Architecture**: Centralized URL handling system
  - Eliminated manual URL construction throughout application
  - Improved consistency in link generation across all interface components
  - Enhanced maintainability with single point of URL logic control
  - Better support for future URL structure modifications
- **Container Optimization**: Streamlined Docker image management
  - Migrated from supervisord.conf to s6-overlay service definitions
  - Enhanced entrypoint script logic now integrated into s6 initialization service
  - Better integration between host configuration and container runtime
  - Enhanced debugging capabilities for containerized deployments
  - Optimized startup performance with efficient file system operations

### Migration Notes

- **Breaking Change**: Containers built with this version no longer use supervisor
- **Security Improvement**: Eliminated multiple CVEs associated with supervisor package
- **Performance Gain**: Reduced container size and improved startup times
- **Industry Standard**: Now using s6-overlay (same as LinuxServer.io, Home Assistant)
- **Compatibility**: All existing functionality preserved during process manager migration

### Backward Compatibility

- **Configuration Migration**: Seamless transition for existing deployments
  - All existing configurations remain fully functional
  - New environment variable configuration supplements rather than replaces existing methods
  - Docker deployments maintain compatibility with previous image versions (except process manager)
  - Non-Docker deployments unaffected by containerization improvements
- **API Compatibility**: No changes to user-facing functionality
  - All web interface features remain identical
  - File browsing, downloading, and viewing functionality unchanged
  - URL structure and routing behavior preserved