## [1.2.0-r1] - 2025-10-03

### Fixed

- **Code Viewer Line Numbers**: Corrected line number alignment with displayed code
  - Line count now calculated from rendered output instead of source input
  - Eliminates mismatches caused by syntax highlighter's HTML markup structure
  - Ensures accurate line numbering for all file types
- **Code Viewer Scrolling**: Unified scroll behavior for line numbers and code content
  - Replaced independent scroll areas with single scrollable container
  - Grid layout prevents separate scrollbars for line numbers and code
  - Line number background now extends full viewport height for short files

### Enhanced

- **File Viewer Consistency**: Code viewer now displays for all text files
  - Line numbers shown regardless of syntax highlighting support
  - Unsupported file types render with line numbers in plain text format
  - Consistent viewing experience across all file extensions

### Docker

- **Volume Architecture**: Redesigned mount structure for improved reliability
  - `/config` and `/app` contents no longer duplicate files
  - Individual symlinks replace directory-level symlink for `.indexer_files`
  - Both volumes can be safely mounted to host without conflicts
  - Config files (`config.json`, `config-reference.txt`) exclusively in `/config`
- **Configuration Management**: Enhanced config file handling
  - `config-reference.txt` refreshed from container defaults on every restart
  - Eliminated potential sync issues between config and app directories
  - Clear separation between user configuration and application runtime files

### Technical

- **CSS Grid Implementation**: Replaced flexbox with grid layout in code viewer
  - Single overflow container ensures synchronized scrolling
  - `min-height: 100%` forces columns to fill viewport
  - Improved mobile and small viewport rendering
- **Symlink Structure**: New individual file/folder linking approach
  ```
  .indexer_files/
  ├── config.json → /config/config.json
  ├── config-reference.txt → /config/config-reference.txt
  ├── icons → /app/icons
  ├── php → /app/php
  └── zip_cache → /app/zip_cache
  ```