Overview
--------
Version 1.1.1 introduces bundle support and significantly improves the download 
experience with better cancellation handling and URL encoding fixes for international 
game names.

Key Changes
----------
- Added Bundle Support
  * New CB (CCLS Bundle) format support alongside existing CG format
  * Enhanced search functionality to handle both games (cg0000) and bundles (cb0000)
  * Updated library listing to display both games and bundles separately
  * Modified get command to support downloading bundles with proper sizing information

- Enhanced Download Cancellation
  * Improved Ctrl+Z cancellation handling in Python downloader
  * Automatic cleanup of partial files when downloads are cancelled
  * Better user feedback during cancellation process
  * Enhanced PowerShell fallback with proper cancellation support

- Improved Download Reliability
  * Fixed URL encoding issues for games with special characters in names
  * Better handling of international characters in download URLs
  * Enhanced connection timeout and retry logic
  * Improved partial file management and cleanup

- Updated User Interface
  * Enhanced help documentation to include bundle commands
  * Better error messages for invalid ID formats
  * Improved feedback for search and get commands
  * Updated library display format for better readability

- Code Improvements
  * Refactored search and download functions to handle both games and bundles
  * Enhanced Python downloader script with better URL normalization
  * Improved error handling for edge cases
  * Better logging and debugging capabilities

- Miscellaneous
  * Updated version number to 1.1.1
  * Enhanced extraction process messaging
  * Improved console output management
  * Better handling of download completion states

This update significantly expands the CLI tool's capabilities by adding full bundle 
support while improving the overall download experience with better cancellation 
handling and enhanced reliability for international content.