# CCLS Games CLI Tool

A powerful PowerShell-based command-line interface for downloading and managing games from the CCLS Games website. This tool provides high-speed downloads, automatic extraction, game library management, and comprehensive game information tracking.

## Features

- **High-Speed Downloads**: Advanced Python-based downloader with resume capabilities
- **Automatic Game Management**: Download, extract, and organize games automatically
- **Interactive Game Browser**: Browse and manage your installed games with detailed information
- **Version Tracking**: Automatic update detection for installed games
- **Library Cache System**: Fast local game library management
- **Startup Message Templates**: Customizable welcome messages
- **Comprehensive Logging**: Detailed session and activity logs
- **Developer Mode**: Offline testing and development features

## Quick Installation

### Prerequisites
- Windows 10 or 11
- Administrator access
- Internet connection
- CCLS Games account ([Sign up here](https://games.ccls.icu/login.php?signup))

### Installation Steps

1. **Download the CLI Tool**
   ```
   Download CLI.ps1 from: https://games.ccls.icu/CLI/api/2.0/latest/CLI.ps1
   Or from: https://github.com/5q12-ccls/CCLS-Games-CLI-Tool/raw/main/CLI.ps1
   ```

2. **Set PowerShell Execution Policy**
   ```powershell
   Set-ExecutionPolicy RemoteSigned -Scope CurrentUser
   ```

3. **Run the Script**
   - Right-click `CLI.ps1` → "Run with PowerShell"
   - Log in with your CCLS Games account
   - Follow the setup prompts

4. **Install Dependencies**
   ```
CCLS>check              # Check what's needed
CCLS>install python     # Install Python
CCLS>install requests   # Install Python requests library
CCLS>install 7zip      # Install 7-Zip for extraction
   ```

5. **Configure Directories**
   ```
CCLS>setup             # Set download and installation paths
   ```

6. **Start Using**
   ```
CCLS>help              # View available commands
CCLS>search library    # Browse available games
CCLS>get [game_id]     # Download a game
CCLS>browse           # Manage installed games
   ```

## Basic Usage

```powershell
# View all available games
CCLS>search library

# Download a specific game
CCLS>get cg0025

# Search for games by name
CCLS>search game tekken

# Browse installed games
CCLS>browse

# View installed games list
CCLS>list all

# Get help for any command
CCLS>[command] help
```

## Documentation

For detailed documentation, please see the following files in the `docs/` folder:

- **[Installation Guide](docs/installation.md)** - Complete installation instructions with troubleshooting
- **[User Guide](docs/user-guide.md)** - Comprehensive usage guide and commands reference
- **[Commands Reference](docs/commands.md)** - Complete list of all available commands
- **[Configuration](docs/configuration.md)** - Advanced configuration options and settings
- **[Troubleshooting](docs/troubleshooting.md)** - Common issues and solutions

## Version History

**Current Version**: 2.1.5

> **Note**: To view all previous versions prior to v2.1.5, visit: https://ccls.icu/src/index.php?path=CCLS-Games-CLI-Tool

## System Requirements

- **Operating System**: Windows 10/11
- **PowerShell**: 5.1 or later (included with Windows)
- **Python**: 3.6+ (auto-installable via CLI)
- **7-Zip**: For file extraction (auto-installable via CLI)
- **Disk Space**: Varies by games downloaded
- **Internet**: Required for downloads and updates

## Project Structure

```
CCLS-Games-CLI-Tool/
├── CLI.ps1                 # Main PowerShell script
├── ccls_downloader.py      # Python high-speed downloader
├── README.md              # This file
├── LICENSE               # Project license
└── docs/                 # Documentation folder
    ├── installation.md
    ├── user-guide.md
    ├── commands.md
    ├── configuration.md
    └── troubleshooting.md
```

## Support

- **Documentation**: Check the `docs/` folder for detailed guides
- **Issues**: Create an issue on this repository
- **Website**: Visit [CCLS Games](https://games.ccls.icu) for account and game-related support

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Links

- **CCLS Games Website**: https://games.ccls.icu
- **Download Latest Version**: https://games.ccls.icu/CLI/api/2.0/latest/CLI.ps1
- **Version Archive**: https://ccls.icu/src/index.php?path=CCLS-Games-CLI-Tool
- **User Registration**: https://games.ccls.icu/login.php?signup