Overview (THE LIBRARY CACHE UPDATE)
--------
Version 2.1.3 introduces a comprehensive library cache system that significantly improves 
performance for game management operations, adds new cache management commands, and 
optimizes loading times for installed game listings while maintaining system reliability.

Key Changes
-----------

Library Cache System Implementation
* NEW: Complete library cache system with automatic cache management and validation
* Added lib.json cache file storing game metadata, sizes, and installation information
* Implemented Initialize-LibraryCache function for cache setup and initial population
* Added Get-LibraryCache and Save-LibraryCache functions for cache file operations
* Created Update-LibraryCache function with force refresh capability
* Added Test-LibraryCacheValid and Test-LibraryCacheIntegrity functions for validation
* Implemented Get-GameFromCache function supporting multiple search types (ID, name, folder)
* Added Handle-CacheError function for graceful error recovery
* Integrated automatic cache updates after game installations and deletions

Performance Optimizations
* Replaced real-time folder scanning with cached data for browse command
* Updated Get-InstalledGames function to use cached game information
* Modified Get-GameInfoByIdentifier to leverage cache for faster lookups
* Enhanced Browse-Games function with instant loading using cached metadata
* Added Get-CachedFolderSize function for optimized size calculations
* Improved startup message templates to use cached data for game listings

New System Commands
* Added sys cache refresh command for manual cache rebuilding
* Added sys cache status command for detailed cache information and diagnostics
* Integrated cache commands into main help system documentation
* Added sys cache help command with comprehensive usage instructions

Browse Function Enhancements
* Modified browse command to load instantly using only cached data
* Updated game information display to show cached metadata first
* Enhanced version checking to only connect to server when explicitly requested
* Improved game type detection using cached metadata flags
* Added better handling for games with and without CCLS metadata

Cache Validation and Maintenance
* Implemented comprehensive cache validation against filesystem changes
* Added detection of modified JSON metadata files through timestamp comparison
* Created automatic cache invalidation when games are added or removed manually
* Added integrity checking for cache structure and data consistency
* Implemented graceful fallback to filesystem scanning when cache is invalid

Startup Message System Updates
* Updated Show-InstalledGamesStartupMessage to use cached game data
* Modified Show-LibraryStatsStartupMessage to leverage cache for statistics
* Enhanced template rendering performance through cached metadata access
* Improved game counting and size calculations using cache totals

Error Handling and Recovery
* Added robust error handling for cache corruption scenarios
* Implemented automatic cache recreation when integrity checks fail
* Added comprehensive logging for cache operations and validation
* Enhanced error messages for cache-related operations
* Improved fallback mechanisms when cache is unavailable

Code Structure Improvements
* Added cache initialization during settings loading
* Integrated cache updates into game installation and deletion workflows
* Enhanced memory management for cache operations
* Improved function organization for cache-related operations
* Added comprehensive documentation for cache system functions

Command System Updates
* Added sys cache commands to main command processing
* Updated help system to include cache management documentation
* Enhanced command validation for cache operations
* Added proper error messaging for cache command failures

Breaking Changes
* None - all cache operations are transparent to existing functionality

Bug Fixes
* Resolved performance issues with large game libraries during browse operations
* Fixed slow loading times for commands that enumerate installed games
* Corrected repeated folder size calculations during game management operations
* Improved memory usage during large library operations
* Fixed potential race conditions in game information retrieval

This release focuses on internal performance improvements while maintaining full backward 
compatibility and adding useful cache management tools for advanced users.