Overview (THE DEPENDENCY ENFORCEMENT UPDATE)
--------
Version 2.1.1 introduces mandatory dependency management, interactive game browsing, 
comprehensive log management, and various system optimizations. This update enforces 
strict dependency requirements for all functionality while providing enhanced user 
experience through better game management capabilities and streamlined operations. 
All dependencies are now required for script operation.

Key Changes
-----------

Mandatory Dependency Management System
* NEW: Strict dependency enforcement with complete functionality blocking
* Added Test-RequiredDependencies function with mandatory validation blocking
* Implemented Assert-DependenciesRequired preventing command execution without dependencies
* Enhanced system requirements checking with critical dependency reporting
* Added dependency satisfaction tracking with script-level state management
* BREAKING: All dependencies (Python, requests, 7-Zip) now required for script operation
* Removed fallback PowerShell downloader - Python with requests now mandatory
* Enhanced user guidance for resolving missing dependencies with clear installation paths

Interactive Game Browser
* NEW: Browse command for interactive installed game management
* Added real-time game status checking with local-first data approach
* Implemented numbered selection interface for game operations
* Added support for view, delete, update, and refresh operations within browser
* Enhanced game information display with installation type detection
* Added support for both CCLS games and manual installations

Comprehensive Log Management
* NEW: Log command with full subcommand suite for log file operations
* Added interactive log browser with file listing and management capabilities
* Implemented log viewing, deletion, and system integration features
* Added support for limiting log display and batch operations
* Enhanced log file handling with size formatting and date sorting
* Added system default application integration for log file opening

Download System Changes
* REMOVED: PowerShell fallback downloader completely eliminated
* Enhanced Python downloader as the sole download method
* Improved dependency validation before any download operations
* Added comprehensive dependency checking for download functionality
* Enhanced error messaging when dependencies are missing
* Streamlined download process with single, reliable Python-based system

Oversight System Optimizations
* Optimized oversight API communication with improved error handling
* Enhanced oversight data retrieval with better session integration
* Improved user logging initialization with proper ID validation
* Streamlined oversight system integration with reduced overhead
* Enhanced global message handling with better color conversion
* Added proper oversight system initialization in auto-login scenarios

Enhanced Dependency Installation
* Enhanced install python command with improved user guidance
* Added detailed installation instructions with PATH configuration warnings
* Improved Python installer process with better error handling and reporting
* Enhanced pip installation recommendations with clearer option descriptions
* Added Python detection improvements with better version reporting
* Enhanced install requests command with dependency validation
* Improved install 7zip command with better installation verification

System Reliability Improvements
* Enhanced script naming validation with automatic CLI.ps1 renaming
* Improved backup creation for existing CLI.ps1 files during renaming
* Added comprehensive error handling for script path detection
* Enhanced settings initialization with better DevMode parameter handling
* Improved version change detection with proper notification handling
* Added dependency state caching for improved performance

User Interface Enhancements
* Enhanced help system with comprehensive command reference
* Added help -list-all and help -a commands for complete command listings
* Improved command help formatting with better organization and examples
* Enhanced error messages with more specific guidance for command usage
* Added better parameter validation with improved user feedback
* Enhanced dependency-related error messages with clear resolution steps

File Tree and Game Information
* Added full directory tree viewing with -tree parameter for list commands
* Enhanced game information display with detailed metadata support
* Improved game folder analysis with better JSON file detection
* Added comprehensive file structure visualization with size information
* Enhanced game identification with multiple search method support

Installation and Update Management
* Improved 7-Zip installation with better folder structure handling
* Enhanced update process with better version detection and validation
* Added mandatory dependency checking integration throughout the system
* Improved installation verification with enhanced error reporting
* Enhanced utility installation with better user feedback and guidance

Performance and Code Optimization
* Optimized function organization with better error handling patterns
* Enhanced memory usage with improved data structure handling
* Streamlined API calls with better caching and session management
* Improved string processing with more efficient search algorithms
* Enhanced file operations with better path handling and validation
* Removed redundant PowerShell download code improving script efficiency

Command System Improvements
* Enhanced command parsing with better parameter handling
* Improved command validation with more specific error messages
* Added comprehensive help integration for all major command categories
* Enhanced command execution flow with better error recovery
* Improved command completion feedback with clearer status reporting
* Added dependency validation integration across all major commands

Breaking Changes
* All dependencies (Python, requests, 7-Zip) are now mandatory for script operation
* PowerShell fallback downloader has been completely removed
* Commands requiring external functionality will be blocked without proper dependencies
* Users must install all required dependencies before using download and extraction features

This release establishes a more reliable and streamlined experience by enforcing 
dependency requirements while providing comprehensive tools for dependency management, 
game browsing, and log operations. The mandatory dependency model ensures consistent 
functionality across all installations.