<?php
// CLI/api/2.0/search.php - Game or Bundle information retrieval for CLI

// Allow CORS from CLI
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');

// Check if username and password were provided
if (!isset($_POST['username']) || empty($_POST['username'])) {
    echo json_encode([
        'success' => false,
        'message' => 'You are running an outdated script version run [update] to fix this issue'
    ]);
    exit;
}

if (!isset($_POST['password']) || empty($_POST['password'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Password is required'
    ]);
    exit;
}

$username = trim($_POST['username']);
$password = trim($_POST['password']);

// Verify user credentials - Updated path for v2.0
$user_files = glob("../../../users/*.json");
$user_authenticated = false;

foreach ($user_files as $file) {
    $user_data = json_decode(file_get_contents($file), true);
    
    if ($user_data['username'] === $username) {
        // Verify password
        if (password_verify($password, $user_data['password'])) {
            $user_authenticated = true;
        }
        break;
    }
}

// If authentication failed, return error
if (!$user_authenticated) {
    echo json_encode([
        'success' => false,
        'message' => 'Authentication failed'
    ]);
    exit;
}

// Check if ID is provided
if (!isset($_POST['id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'ID is required'
    ]);
    exit;
}

$id = $_POST['id'];

// Determine if this is a game or bundle ID based on prefix
$is_bundle = (strpos($id, 'cb') === 0);

if ($is_bundle) {
    $file_path = "../../../bundles/{$id}.json";
} else {
    $file_path = "../../../titles/{$id}.json";
}

// Check if file exists
if (!file_exists($file_path)) {
    echo json_encode([
        'success' => false,
        'message' => ($is_bundle ? 'Bundle' : 'Game') . ' not found'
    ]);
    exit;
}

// Load and return data
try {
    $data = json_decode(file_get_contents($file_path), true);
    
    // Set success flag for CLI tool
    $data['success'] = true;
    
    // Add type indicator
    $data['type'] = $is_bundle ? 'bundle' : 'game';
    
    // Return the data as JSON
    echo json_encode($data);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error loading ' . ($is_bundle ? 'bundle' : 'game') . ' data: ' . $e->getMessage()
    ]);
}
?>