# Installation Guide

This guide provides detailed instructions for installing and setting up the CCLS Games CLI Tool.

## Table of Contents

1. [Prerequisites](#prerequisites)
2. [Downloading the CLI Tool](#downloading-the-cli-tool)
3. [PowerShell Security Configuration](#powershell-security-configuration)
4. [First Run Setup](#first-run-setup)
5. [Installing Dependencies](#installing-dependencies)
6. [Directory Configuration](#directory-configuration)
7. [Verification](#verification)
8. [Troubleshooting Installation](#troubleshooting-installation)

## Prerequisites

Before installing the CCLS Games CLI Tool, ensure you have:

### System Requirements
- **Operating System**: Windows 10 (build 1903 or later) or Windows 11
- **PowerShell**: Version 5.1 or later (included with Windows)
- **Administrator Access**: Required for initial setup and dependency installation
- **Internet Connection**: Required for downloads and updates
- **Disk Space**: At least 1GB free space (more recommended for games)

### Account Requirements
- **CCLS Games Account**: Required for downloading games
  - Create account at: https://games.ccls.icu/login.php?signup
  - Existing users can log in with their credentials

## Downloading the CLI Tool

### Method 1: Direct Download (Recommended)
1. Visit the download page: https://games.ccls.icu/CLI_Tool.php
2. Click "Download CLI Tool" to get the latest version
3. Save the `CLI.ps1` file to a dedicated folder

### Method 2: Direct Link
```
https://games.ccls.icu/CLI/api/2.0/latest/CLI.ps1
```

### Creating a Dedicated Folder
1. Create a new folder for the CLI Tool (recommended locations):
   - `C:\Users\[YourUsername]\Documents\CCLS-CLI\`
   - `C:\CCLS-CLI\`
   - Desktop folder (for easy access)
2. Place the downloaded `CLI.ps1` file in this folder
3. This folder will also store settings, logs, and cache files

## PowerShell Security Configuration

Windows PowerShell has security features that prevent unauthorized scripts from running. You need to configure the execution policy:

### Step 1: Open PowerShell as Administrator
1. Click the Start menu
2. Type "PowerShell"
3. Right-click "Windows PowerShell"
4. Select "Run as administrator"
5. Click "Yes" when prompted by User Account Control

### Step 2: Set Execution Policy
In the administrator PowerShell window, run:
```powershell
Set-ExecutionPolicy RemoteSigned -Scope CurrentUser
```

When prompted, type `A` (Yes to All) and press Enter.

### What This Does
- `RemoteSigned`: Allows local scripts to run while requiring downloaded scripts to be signed
- `-Scope CurrentUser`: Only affects your user account, not system-wide
- This is a secure setting that balances safety with functionality

## First Run Setup

### Step 1: Handle Security Warning
1. Navigate to your CLI Tool folder
2. Right-click `CLI.ps1`
3. Select "Run with PowerShell"
4. Windows will show a security warning dialog
5. **Important**: Uncheck "Always ask before opening this file"
6. Click "Open"

### Step 2: Login Process
The script will prompt you to log in:

**For existing users:**
```
Username: [your_username]
Password: [your_password]
```

**For new users:**
- The script will display a registration link
- Visit the link to create an account
- Return to the script and log in

### Step 3: Save Login Information
After successful login, you'll be asked:
```
Do you want to remember your login info for next time? (Y/N)
```
- Type `Y` for automatic login on future runs (recommended)
- Type `N` to manually log in each time

## Installing Dependencies

The CLI Tool requires several components for full functionality. Use the built-in installer commands:

### Step 1: Check Current Status
```
CCLS>check
```
This command shows which components are installed and which are missing.

### Step 2: Install Required Components

#### 7-Zip (Required)
```
CCLS>install 7zip
```
- **Purpose**: Extracts downloaded game archives
- **Installation**: Downloads and installs 7-Zip locally
- **Required**: Games cannot be installed without 7-Zip

#### Python (Required)
```
CCLS>install python
```
- **Purpose**: Enables high-speed downloading with resume capability
- **Installation**: Downloads Python installer and guides you through setup
- **Important**: When installing Python, check "Add Python to PATH"
- **Restart Required**: Restart the CLI Tool after Python installation

#### Python Requests Library (Required)
```
CCLS>install requests
```
- **Purpose**: HTTP library for download functionality
- **Installation**: Automatically installs via pip
- **Prerequisite**: Python must be installed first

### Installation Order
1. Install 7-Zip first
2. Install Python second
3. Restart CLI Tool
4. Install requests library
5. Run `check` command to verify all components

## Directory Configuration

Before downloading games, you must configure the CLI Tool directories:

### Run Setup Command
```
CCLS>setup
```

### Configure Directories

#### Games Installation Directory
- **Purpose**: Where downloaded games are permanently stored
- **Recommendations**: 
  - Choose a location with plenty of free space
  - Use a fast drive (SSD preferred) for better performance
  - Example: `C:\Games\CCLS-Games\`

#### Temporary Download Directory
- **Purpose**: Temporary storage during download and extraction
- **Recommendations**:
  - Can be on a different drive from installation directory
  - Should have space for the largest game you plan to download
  - Example: `C:\Temp\CCLS-Downloads\`

### Directory Structure Created
After setup, the CLI Tool creates several folders:
```
[Installation Directory]/
├── [Game Folders]/
│   ├── [Game Files]
│   └── [Game ID].json (metadata)
└── ...

[CLI Tool Directory]/
├── CLI.ps1
├── settings/
│   ├── credentials.dat
│   ├── settings.json
│   └── lib.json (cache)
├── logs/
│   └── [session logs]
└── 7zip/ (if installed locally)
```

## Verification

### Verify Installation
1. Run the check command:
   ```
   CCLS>check
   ```
2. All components should show as "Installed"

### Test Basic Functionality
1. List available games:
   ```
   CCLS>search library
   ```
2. View help:
   ```
   CCLS>help
   ```

### Test Download (Optional)
1. Search for a small game:
   ```
   CCLS>search library
   ```
2. Download a test game:
   ```
   CCLS>get [small_game_id]
   ```

## Troubleshooting Installation

### Common Issues

#### "Execution Policy" Error
**Problem**: PowerShell refuses to run the script
**Solution**: 
1. Run PowerShell as Administrator
2. Execute: `Set-ExecutionPolicy RemoteSigned -Scope CurrentUser`

#### "Python not found" After Installation
**Problem**: CLI Tool can't find Python after installation
**Solutions**:
1. Restart the CLI Tool completely
2. Verify Python is in PATH: `python --version` in Command Prompt
3. Reinstall Python with "Add Python to PATH" checked

#### "7-Zip not found" Error
**Problem**: Extraction fails during game installation
**Solutions**:
1. Run: `install 7zip` again
2. Check if 7-Zip installed correctly
3. Manually install 7-Zip from https://www.7-zip.org/

#### "Setup command required" Error
**Problem**: Cannot download games
**Solution**: Run the `setup` command to configure directories

#### Windows Security Warning Keeps Appearing
**Problem**: Security dialog shows every time
**Solution**: Uncheck "Always ask before opening this file" in the security dialog

#### "Missing critical dependencies" Error
**Problem**: CLI Tool reports broken state
**Solution**: 
1. Run `check` to see what's missing
2. Install missing components using `install [component]`
3. Restart CLI Tool if needed

### Advanced Troubleshooting

#### Reset CLI Tool Configuration
If you encounter persistent issues:
1. Close the CLI Tool
2. Delete the `settings` folder in your CLI Tool directory
3. Restart the CLI Tool and run through setup again

#### Manual Python Installation
If automatic Python installation fails:
1. Visit https://www.python.org/downloads/
2. Download Python 3.x for Windows
3. During installation, check "Add Python to PATH"
4. After installation, restart CLI Tool
5. Run: `install requests`

#### Check System Logs
For advanced troubleshooting:
1. Use the log system: `log list`
2. View recent logs: `log view [filename]`
3. Check Windows Event Viewer for system-level errors

### Getting Help

If you continue to experience issues:
1. Check the [Troubleshooting Guide](troubleshooting.md)
2. Review the [User Guide](user-guide.md) for usage questions
3. Create an issue on the project repository
4. Visit the CCLS Games website for account-related issues

## Next Steps

After successful installation:
1. Read the [User Guide](user-guide.md) for comprehensive usage instructions
2. Review the [Commands Reference](commands.md) for all available commands
3. Explore the [Configuration Guide](configuration.md) for advanced settings