<?php
// CLI/api/2.0/changelogs_list.php - Lists all changelog files available
header('Content-Type: application/json');

// Directory with the changelog files - Updated path to remain in 1.0 location
$changelogs_dir = '../../changelogs/';

// Get all txt files in the directory
$files = glob($changelogs_dir . '*.txt');

// Extract just the version numbers
$versions = [];
foreach ($files as $file) {
    // Extract the version from the filename (e.g., "changelogs/1.1.3.txt" -> "1.1.3")
    $version = basename($file, '.txt');
    $versions[] = $version;
}

// Sort versions (natural version sorting)
usort($versions, 'version_compare');

// Return the list as JSON
echo json_encode($versions);
?>