<?php
// CLI/api/2.0/login_check.php
// This file checks if a username/password combination is valid
// Used for stored credentials verification

// Prevent direct web access to this script
if (!isset($_SERVER['HTTP_USER_AGENT']) || strpos($_SERVER['HTTP_USER_AGENT'], 'CCLS-CLI') === false) {
    header('HTTP/1.0 403 Forbidden');
    echo json_encode(['error' => 'Access denied']);
    exit;
}

// Initialize response
$response = [
    'success' => false,
    'error' => null
];

// Check if username and password were provided
if (!isset($_POST['username']) || empty($_POST['username'])) {
    $response['error'] = 'Username is required';
    echo json_encode($response);
    exit;
}

if (!isset($_POST['password']) || empty($_POST['password'])) {
    $response['error'] = 'Password is required';
    echo json_encode($response);
    exit;
}

$username = trim($_POST['username']);
$password = trim($_POST['password']);

// Check if username exists and password matches - Updated path for v2.0
$user_files = glob("../../../users/*.json");
$user_found = false;

foreach ($user_files as $file) {
    $user_data = json_decode(file_get_contents($file), true);
    
    if ($user_data['username'] === $username) {
        // Verify password
        if (password_verify($password, $user_data['password'])) {
            // Update last login time
            $user_data['last_login'] = time();
            file_put_contents($file, json_encode($user_data));
            
            $response['success'] = true;
            $response['user_id'] = $user_data['user_id'];
        }
        $user_found = true;
        break;
    }
}

if (!$user_found) {
    $response['error'] = 'User not found';
}

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response);
?>