# Commands Reference

Complete reference guide for all CCLS Games CLI Tool commands, organized by category with detailed syntax and examples.

## Table of Contents

1. [Command Syntax](#command-syntax)
2. [Basic Commands](#basic-commands)
3. [Search Commands](#search-commands)
4. [Download Commands](#download-commands)
5. [Game Management Commands](#game-management-commands)
6. [Browse Commands](#browse-commands)
7. [Delete Commands](#delete-commands)
8. [System Commands](#system-commands)
9. [Log Commands](#log-commands)
10. [Version Commands](#version-commands)
11. [Utility Commands](#utility-commands)
12. [Developer Commands](#developer-commands)

## Command Syntax

### General Format
```
CCLS>[command] [parameters] [options]
```

### Common Conventions
- `[required]` - Required parameter
- `[optional]` - Optional parameter
- `[command] help` - Get help for any command
- `-y` - Skip confirmation prompts
- `-d` - Show detailed information
- `-tree` - Show file tree structure

### Parameter Types
- **Game ID**: Format `cg0000` for games, `cb0000` for bundles
- **Game Name**: Case-insensitive, supports partial matching
- **Folder Name**: Name of installed game folder
- **Filename**: Log file or template name

## Basic Commands

### help
Display help information.

**Syntax:**
```
help
help -a
help -list-all
```

**Examples:**
```
CCLS>help               # Basic help overview
CCLS>help -a            # Complete command reference
CCLS>help -list-all     # Same as help -a
```

### clear / cls
Clear the console screen.

**Syntax:**
```
clear
cls
```

**Examples:**
```
CCLS>clear              # Clear console
CCLS>cls                # Alternative command
```

### exit / quit
Exit the CLI Tool.

**Syntax:**
```
exit
quit
```

**Examples:**
```
CCLS>exit               # Exit application
CCLS>quit               # Alternative command
```

### logout
Log out and return to login screen.

**Syntax:**
```
logout
```

**Examples:**
```
CCLS>logout             # Log out and re-login
```

### forget
Remove stored login credentials.

**Syntax:**
```
forget
```

**Examples:**
```
CCLS>forget             # Remove saved credentials
```

## Search Commands

### search
Search for games and bundles.

**Syntax:**
```
search [game_id]
search game [search_term]
search library
search lib
search help
```

**Parameters:**
- `[game_id]` - Game ID (cg0000) or bundle ID (cb0000)
- `[search_term]` - Text to search for in game names
- `library/lib` - Show complete game library

**Examples:**
```
CCLS>search cg0025                 # Get info for specific game
CCLS>search cb0010                 # Get info for specific bundle
CCLS>search game tekken            # Search for games matching "tekken"
CCLS>search game assassin          # Search for Assassin's Creed games
CCLS>search library                # Show all available games/bundles
CCLS>search lib                    # Short form of library
CCLS>search help                   # Show search command help
```

**Search Game Features:**
- Fuzzy matching for game names
- Interactive selection menu
- Direct download option (`get [number]`)
- Ranked results (exact matches first)

## Download Commands

### get
Download and install games or bundles.

**Syntax:**
```
get [game_id] [-y]
get game [game_name] [-y]
get help
```

**Parameters:**
- `[game_id]` - Game ID (cg0000) or bundle ID (cb0000)
- `[game_name]` - Name of game to download
- `-y` - Skip confirmation prompts

**Examples:**
```
CCLS>get cg0025                    # Download game by ID
CCLS>get cb0010                    # Download bundle by ID
CCLS>get cg0025 -y                 # Download without confirmation
CCLS>get game tekken 8             # Download by name
CCLS>get game plateup -y           # Download by name, no confirmation
CCLS>get help                      # Show get command help
```

**Download Process:**
1. Validates game ID/name
2. Shows game information
3. Confirms download (unless -y used)
4. Downloads with progress tracking
5. Extracts automatically
6. Saves metadata

## Game Management Commands

### list
Display information about installed games.

**Syntax:**
```
list all [-d]
list [identifier] [-d] [-tree]
list game [game_name] [-d] [-tree]
list gamedir [folder_name] [-d] [-tree]
list help
```

**Parameters:**
- `all` - Show all installed games
- `[identifier]` - Game ID, folder name, or game name
- `[game_name]` - Specific game name
- `[folder_name]` - Specific folder name
- `-d` - Show detailed information
- `-tree` - Show complete file tree

**Examples:**
```
CCLS>list all                      # List all games (basic)
CCLS>list all -d                   # List all games (detailed)
CCLS>list cg0025                   # Info for specific game by ID
CCLS>list cg0025 -d                # Detailed info by ID
CCLS>list cg0025 -tree             # File tree by ID
CCLS>list cg0025 -tree -d          # Detailed info + file tree
CCLS>list game tekken 8            # Info by game name
CCLS>list gamedir "The Long Drive" # Info by folder name
CCLS>list help                     # Show list command help
```

**Information Displayed:**
- Game name and ID
- Installation size
- Version information
- Update status
- File tree (with -tree option)
- System requirements (with -d option)

## Browse Commands

### browse
Enter interactive game browser mode.

**Syntax:**
```
browse
browse help
```

**Examples:**
```
CCLS>browse                        # Enter browse mode
CCLS>browse help                   # Show browse help
```

**Browse Mode Commands:**
- `view [number]` - View game details
- `del [number]` - Delete game
- `update [number]` - Check for updates
- `refresh [number]` - Refresh online info
- `[number]` - Same as view [number]
- `[Enter]` - Exit browse mode

**Browse Features:**
- Fast local-first interface
- Color-coded game status
- Real-time update checking
- Comprehensive game management

## Delete Commands

### del
Delete installed games.

**Syntax:**
```
del [identifier] [-y]
del game [game_name] [-y]
del gamedir [folder_name] [-y]
del help
```

**Parameters:**
- `[identifier]` - Game ID, folder name, or game name
- `[game_name]` - Specific game name
- `[folder_name]` - Specific folder name
- `-y` - Skip confirmation prompt

**Examples:**
```
CCLS>del cg0025                    # Delete by game ID
CCLS>del "The Long Drive"          # Delete by folder name
CCLS>del game tekken 8             # Delete by game name
CCLS>del cg0025 -y                 # Delete without confirmation
CCLS>del help                      # Show delete command help
```

**Safety Features:**
- Confirmation prompts (unless -y used)
- Shows game size before deletion
- Displays complete path
- Updates library cache automatically

## System Commands

### sys
System management and configuration.

**Syntax:**
```
sys cache status
sys cache refresh
sys start-message [action] [template]
sys help
```

**Cache Commands:**
```
CCLS>sys cache status              # Show cache information
CCLS>sys cache refresh             # Rebuild library cache
CCLS>sys cache help                # Cache system help
```

**Startup Message Commands:**
```
CCLS>sys start-message list        # List available templates
CCLS>sys start-message get [name]  # Download template
CCLS>sys start-message enable [name] # Enable template
CCLS>sys start-message get,enable [name] # Download and enable
CCLS>sys start-message try [name]  # Preview template
CCLS>sys start-message view        # View current message
CCLS>sys start-message default     # Disable custom messages
CCLS>sys start-message del [name]  # Delete template
CCLS>sys start-message wipe        # Delete all templates
CCLS>sys start-message help        # Startup message help
```

### setup
Configure CLI Tool directories.

**Syntax:**
```
setup
```

**Examples:**
```
CCLS>setup                         # Configure installation directories
```

**Configuration Options:**
- Games installation directory
- Temporary download directory
- Creates necessary folder structure

### check
Check system requirements and dependencies.

**Syntax:**
```
check
```

**Examples:**
```
CCLS>check                         # Check all dependencies
```

**Checks Performed:**
- Python installation and version
- Python requests library
- 7-Zip installation
- PowerShell version
- Available disk space

### install
Install required dependencies.

**Syntax:**
```
install [utility]
install help
```

**Supported Utilities:**
- `python` - Install Python interpreter
- `requests` - Install Python requests library
- `7zip` - Install 7-Zip extraction utility

**Examples:**
```
CCLS>install python                # Install Python
CCLS>install requests              # Install Python requests
CCLS>install 7zip                  # Install 7-Zip
CCLS>install help                  # Show install help
```

## Log Commands

### log
Manage session logs and history.

**Syntax:**
```
log list [-a|-all|-[number]]
log view [filename]
log del [filename] [-y]
log open [filename]
log help
```

**Parameters:**
- `[filename]` - Specific log file name
- `-a/-all` - Show all log files (default)
- `-[number]` - Limit to specific number of files
- `-y` - Skip confirmation for deletion

**Examples:**
```
CCLS>log list                      # Browse all logs interactively
CCLS>log list -5                   # Show 5 newest logs
CCLS>log list -all                 # Show all logs (explicit)
CCLS>log view session_2024.log     # View specific log file
CCLS>log del old_session.log       # Delete log with confirmation
CCLS>log del old_session.log -y    # Delete without confirmation
CCLS>log open session_2024.log     # Open with default editor
CCLS>log help                      # Show log command help
```

**Log Browser Features:**
- Interactive file selection
- Color-coded file age
- File size and date information
- Search and filter capabilities

## Version Commands

### version
Display version information.

**Syntax:**
```
version
```

**Examples:**
```
CCLS>version                       # Show current version and update status
```

### update
Update CLI Tool to latest version.

**Syntax:**
```
update
```

**Examples:**
```
CCLS>update                        # Update to latest version
```

**Update Process:**
1. Checks for latest version
2. Downloads update
3. Creates backup of current version
4. Replaces with new version
5. Requires restart to apply

### changelog
View version history and changes.

**Syntax:**
```
changelog [version]
changelog list
changelog latest
changelog help
```

**Parameters:**
- `[version]` - Specific version number
- `list` - Show all available changelogs
- `latest` - Show changes in latest version

**Examples:**
```
CCLS>changelog 2.1.4               # Show changes in v2.1.4
CCLS>changelog list                # List all available versions
CCLS>changelog latest              # Show latest version changes
CCLS>changelog help                # Show changelog help
```

## Utility Commands

### devmode
Toggle Developer Mode.

**Syntax:**
```
devmode
devmode help
```

**Examples:**
```
CCLS>devmode                       # Toggle developer mode on/off
CCLS>devmode help                  # Show developer mode help
```

**Developer Mode Features:**
- No login required
- Offline functionality
- Disabled online API calls
- Testing and development use

## Command Categories Summary

### Essential Commands
```
help, search library, get [id], browse, list all
```

### Game Discovery
```
search library, search game [term], search [id]
```

### Game Management
```
get [id], list [game], del [game], browse
```

### System Maintenance
```
check, install [utility], setup, update, version
```

### Advanced Features
```
sys cache refresh, log list, changelog [version]
```

### Quick Reference
```
help                    # Basic help
help -a                 # All commands
search library          # Browse games
get [id]               # Download game
browse                 # Manage games
list all               # Show installed
check                  # Check system
setup                  # Configure
```

## Command Help System

Every command category has built-in help:
```
search help             # Search command help
get help               # Download command help
list help              # List command help
del help               # Delete command help
install help           # Install command help
log help               # Log command help
browse help            # Browse command help
changelog help         # Changelog command help
sys help               # System command help
devmode help           # Developer mode help
```

## Tips for Effective Usage

### Use Tab Completion
Many terminals support tab completion for faster command entry.

### Command Aliases
Some commands have shorter aliases:
- `search lib` instead of `search library`
- `cls` instead of `clear`

### Batch Operations
Use `-y` flag for scripted or batch operations to skip confirmations.

### Help Integration
Every command has contextual help available with the `help` parameter.

### Error Handling
Commands provide clear error messages and suggest corrections for common mistakes.