# Configuration Guide

This guide covers advanced configuration options, settings management, and customization features of the CCLS Games CLI Tool.

## Table of Contents

1. [Configuration Overview](#configuration-overview)
2. [Settings File Structure](#settings-file-structure)
3. [Directory Configuration](#directory-configuration)
4. [Cache Management](#cache-management)
5. [Credential Management](#credential-management)
6. [Logging Configuration](#logging-configuration)
7. [Startup Messages](#startup-messages)
8. [Performance Tuning](#performance-tuning)
9. [Security Settings](#security-settings)
10. [Advanced Options](#advanced-options)

## Configuration Overview

The CLI Tool stores its configuration in the `settings/` folder within the script directory:

```
[CLI Tool Directory]/
├── CLI.ps1
├── settings/
│   ├── settings.json          # Main configuration
│   ├── credentials.dat         # Encrypted login credentials
│   ├── lib.json               # Library cache
│   └── start-message/         # Startup message templates
│       ├── default/
│       │   ├── template.json
│       │   └── info.txt
│       └── [template_name].json
└── logs/                      # Session logs
    └── ccls_session_*.log
```

## Settings File Structure

### settings.json
The main configuration file containing user preferences and system settings:

```json
{
    "RememberLogin": true,
    "DownloadPath": "C:\\Games\\CCLS-Games",
    "TempDownloadPath": "C:\\Temp\\CCLS-Downloads",
    "HasCompletedSetup": true,
    "Version": "2.1.5",
    "DevMode": false
}
```

### Configuration Parameters

#### RememberLogin
- **Type**: Boolean
- **Default**: `false`
- **Description**: Enables automatic login using stored credentials
- **Security Note**: Credentials are encrypted using Windows DPAPI

#### DownloadPath
- **Type**: String (File Path)
- **Default**: `".\downloads"`
- **Description**: Directory where games are permanently installed
- **Requirements**: Must be writable, sufficient disk space recommended

#### TempDownloadPath
- **Type**: String (File Path)
- **Default**: `".\tmp"`
- **Description**: Temporary directory for downloads and extraction
- **Requirements**: Must be writable, space for largest game download

#### HasCompletedSetup
- **Type**: Boolean
- **Default**: `false`
- **Description**: Tracks whether initial setup has been completed
- **Note**: Set to `true` after running the `setup` command

#### Version
- **Type**: String
- **Default**: Current CLI Tool version
- **Description**: Tracks installed version for update detection
- **Note**: Automatically updated during version upgrades

#### DevMode
- **Type**: Boolean
- **Default**: `false`
- **Description**: Enables Developer Mode for offline testing
- **Features**: Disables online API calls, allows local-only operation

## Directory Configuration

### Initial Setup
Configure directories using the interactive setup command:
```
CCLS>setup
```

### Manual Configuration
Edit the `settings.json` file directly to change paths:

```json
{
    "DownloadPath": "D:\\Games\\CCLS",
    "TempDownloadPath": "E:\\Temp\\Downloads"
}
```

### Path Requirements

#### Download Path
- **Purpose**: Permanent game storage
- **Recommendations**:
  - Use fast storage (SSD preferred)
  - Ensure adequate space (100GB+ recommended)
  - Choose easily accessible location
  - Avoid system directories

#### Temp Download Path
- **Purpose**: Temporary file storage during downloads
- **Recommendations**:
  - Can be on different drive from DownloadPath
  - Should have space for largest expected download
  - Fast I/O performance beneficial
  - Regular cleanup recommended

### Path Validation
The CLI Tool validates paths during:
- Initial setup
- Settings load
- Game download initiation

Invalid paths trigger:
- Error messages
- Automatic directory creation (if possible)
- Fallback to default locations

## Cache Management

### Library Cache (lib.json)
Stores metadata about installed games for fast access:

```json
{
    "lastUpdated": "2024-01-15 14:30:25",
    "totalGames": 25,
    "totalSize": 524288000000,
    "totalSizeFormatted": "488.28 GB",
    "games": [
        {
            "folderName": "The Long Drive",
            "gameName": "The Long Drive",
            "gameId": "cg0023",
            "localVersion": "1.2.0",
            "localSize": 2147483648,
            "localSizeFormatted": "2.00 GB",
            "localPath": "C:\\Games\\CCLS-Games\\The Long Drive",
            "hasMetadata": true,
            "isOutdated": false,
            "onlineVersion": "1.2.0",
            "jsonLastModified": "2024-01-15 10:15:30"
        }
    ]
}
```

### Cache Management Commands
```
CCLS>sys cache status              # View cache information
CCLS>sys cache refresh             # Rebuild cache
```

### Cache Invalidation
The cache is automatically refreshed when:
- Games are installed or deleted
- Game folders are modified
- JSON metadata files change
- Cache validation fails

### Manual Cache Maintenance
For corrupted or outdated cache:
1. Delete `settings/lib.json`
2. Restart CLI Tool
3. Cache will be rebuilt automatically

## Credential Management

### Storage Method
Credentials are encrypted using Windows Data Protection API (DPAPI):
- User-specific encryption
- Machine-bound security
- No cross-user access
- Automatic decryption for owner

### Credential File (credentials.dat)
Binary file containing encrypted login information:
- Username and password
- Encrypted per-user
- Automatically created when "Remember Login" is enabled

### Security Features
- **Encryption**: Windows DPAPI with user context
- **Access Control**: File system permissions
- **Automatic Cleanup**: Cleared on logout/forget commands
- **Validation**: Credentials verified on each use

### Credential Commands
```
CCLS>forget                        # Remove stored credentials
CCLS>logout                        # Log out and clear session
```

### Security Best Practices
- Regular password changes
- Avoid shared computers for saved credentials
- Use `forget` command before system transfers
- Monitor for unauthorized access

## Logging Configuration

### Log File Naming
```
ccls_session_YYYY-MM-DD_HH-mm-ss.log
```

### Log Levels
The CLI Tool uses different log entry types:
- **Standard Entries**: User commands and responses
- **Debug Entries**: Internal operations (prefixed with #)
- **Error Entries**: Exception and error information
- **System Entries**: Session start/end, configuration changes

### Log Retention
- **Automatic**: No automatic cleanup
- **Manual**: Use log management commands
- **Storage**: Limited only by disk space

### Log Management
```
CCLS>log list                      # Browse and manage logs
CCLS>log del [filename]            # Delete specific log
```

### Privacy Considerations
Logs may contain:
- Usernames (not passwords)
- File paths
- Game names and IDs
- System information
- Error details

## Startup Messages

### Template System
Customizable welcome screens displayed after login.

### Template Structure
```json
{
    "template": {
        "type": "static",
        "messages": [
            {
                "text": "Welcome to CCLS Games!",
                "color": "Green",
                "newline": true
            },
            {
                "text": "Ready to game? ",
                "color": "Cyan",
                "newline": false
            }
        ]
    }
}
```

### Dynamic Templates
Special templates that show real-time data:
- `installed_games`: Shows installed game list
- `library_stats`: Displays library statistics

### Template Management
```
CCLS>sys start-message list              # Available templates
CCLS>sys start-message get [name]        # Download template
CCLS>sys start-message enable [name]     # Enable template
CCLS>sys start-message default           # Disable custom messages
```

### Custom Template Creation
1. Create JSON file with template structure
2. Place in `settings/start-message/` folder
3. Enable using `sys start-message enable [name]`

## Performance Tuning

### Download Performance
- **Python Installation**: Enables high-speed downloads
- **Requests Library**: Required for optimal performance
- **Disk I/O**: Use fast storage for temp directory
- **Network**: Stable high-speed connection recommended

### Cache Performance
- **SSD Storage**: Faster cache access
- **Regular Refresh**: Maintain cache validity
- **Size Management**: Monitor cache file growth

### Memory Optimization
- **Session Length**: Restart for long sessions
- **Large Libraries**: Regular cache refresh
- **Log Cleanup**: Remove old log files

### System Requirements Optimization
```
CCLS>check                         # Verify optimal configuration
```

## Security Settings

### PowerShell Execution Policy
Required setting for script execution:
```powershell
Set-ExecutionPolicy RemoteSigned -Scope CurrentUser
```

### File System Permissions
Ensure appropriate permissions:
- CLI Tool directory: Read/Write/Execute
- Download directories: Full control
- Settings folder: Read/Write

### Network Security
- **HTTPS**: All API communications use HTTPS
- **Certificate Validation**: SSL certificates verified
- **User-Agent**: Identifies CLI Tool to server

### Data Protection
- **Credentials**: Encrypted using DPAPI
- **Local Storage**: No plain-text passwords
- **Transmission**: Secure HTTPS protocol

## Advanced Options

### Developer Mode
Enable for testing and development:
```
CCLS>devmode                       # Toggle developer mode
```

Features in Developer Mode:
- No login required
- Offline operation
- Disabled online API calls
- Local command testing

### Environment Variables
The CLI Tool respects these environment variables:
- `TEMP`: Used for temporary file operations
- `USERPROFILE`: Used for default paths
- `PATH`: Required for Python detection

### Command Line Parameters
Currently, the CLI Tool doesn't support command-line parameters, but this may be added in future versions.

### Debugging Features
For troubleshooting:
- Enable debug mode in source code
- Detailed logging automatically enabled
- Error tracking and reporting
- Performance monitoring

### Backup and Restore

#### Configuration Backup
To backup your configuration:
1. Copy the entire `settings/` folder
2. Store in secure location
3. Restore by copying back to CLI Tool directory

#### Game Metadata Backup
Game metadata is stored in:
- Individual `[GameID].json` files in game folders
- Library cache (`lib.json`)
- Session logs for installation history

#### Restore Process
1. Copy settings folder to new installation
2. Update paths in `settings.json` if needed
3. Run `sys cache refresh` to rebuild cache
4. Verify with `check` command

### Migration Between Systems
When moving to a new computer:
1. Copy CLI Tool directory
2. Update paths in settings.json
3. Clear credentials.dat (machine-specific)
4. Re-run setup if needed
5. Re-authenticate with login

### Troubleshooting Configuration
Common configuration issues:
- **Invalid Paths**: Use `setup` command to reconfigure
- **Corrupted Settings**: Delete settings.json to reset
- **Cache Issues**: Use `sys cache refresh`
- **Permission Problems**: Run as administrator for setup