Overview
--------
Version 1.1.2 introduces enhanced authentication security and session management
improvements to provide better user experience and more secure credential handling.

Key Changes
----------
- Enhanced Authentication System
  * Added session-level credential caching for improved security
  * Credentials now cached in memory during active sessions
  * Reduced server authentication requests for better performance

- Improved API Security
  * Updated search functionality to use POST requests with credentials
  * Enhanced get functionality with proper credential validation
  * Added credential validation for library listing operations

- Better Session Management
  * Credentials automatically cleared when session ends
  * Enhanced error handling for authentication failures
  * Improved login validation and error messages

- Enhanced User Interface
  * Added 'version' command to display current version and check for updates
  * Better version checking and update notification system
  * Improved help documentation with version command information

- Code Improvements
  * Refactored credential handling functions for better security
  * Enhanced error handling for network operations
  * Improved authentication flow and session management

- Miscellaneous
  * Updated version number to 1.1.2
  * Minor bug fixes for authentication edge cases
  * Improved stability for long-running sessions

This update focuses on strengthening the authentication system while maintaining
ease of use. The credential caching system ensures users stay authenticated
throughout their session while keeping credentials secure in memory only.