Overview
--------
Version 1.1.8 introduces user-friendly command improvements focused on enhancing accessibility
and ease of use. This update adds convenient command shortcuts and flexible game name support 
to streamline the user experience.

Key Changes
----------
- Enhanced Search Commands
  * Added 'search lib' as a shortcut for 'search library' command
  * Provides quick access to the complete game and bundle library
  * Maintains full compatibility with existing 'search library' functionality

- Flexible Game Name Support for Downloads
  * New 'get game [gamename]' command syntax for downloading by game name
  * Intelligent fuzzy matching finds games without requiring exact names
  * Case-insensitive game name recognition for improved usability
  * Automatically matches closest corresponding game from the library
  * Eliminates need to remember specific CG/CB ID numbers

- User Experience Improvements
  * Simplified workflow for users who prefer game names over ID codes
  * More intuitive command structure for new users
  * Reduced dependency on exact spelling and capitalization
  * Maintains backward compatibility with existing ID-based commands

- Miscellaneous
  * Updated version number to 1.1.8
  * Minor performance improvements for name matching algorithms
  * Enhanced command parsing for better flexibility

This update focuses on making the CLI tool more accessible to users who prefer working with game names
rather than ID codes, while maintaining all existing functionality and ensuring a seamless experience
for both new and experienced users.