Overview
--------
Version 1.1.3 introduces utility installation support and system requirements checking
to provide better user experience and streamlined setup for required dependencies.

Key Changes
----------
- Added Utility Installation System
  * New 'install' command to download and install required utilities
  * Support for 7-Zip installation with 'install 7zip' command
  * Support for Python requests library installation with 'install requests' command
  * Automatic extraction and setup of downloaded utilities

- Enhanced System Requirements Checking
  * New 'check' command to verify system requirements
  * Comprehensive checking for Python, Python requests library, and 7-Zip
  * Version detection for installed components
  * Clear feedback on missing or outdated dependencies

- Improved Game Extraction Functionality
  * New 'extract' command for manual extraction of downloaded files
  * Support for extracting by game/bundle ID (cg0000/cb0000)
  * Support for extracting by filename
  * Enhanced error handling for missing 7-Zip installation

- Better User Interface
  * Updated help documentation with new commands
  * Improved error messages for extraction processes
  * Better guidance for installing missing dependencies
  * Enhanced command line feedback and instructions

- Code Improvements
  * Refactored extraction logic for better maintainability
  * Added comprehensive utility installation functions
  * Enhanced error handling for download and installation processes
  * Improved system detection and validation

- Miscellaneous
  * Updated version number to 1.1.3
  * Minor bug fixes for extraction workflows
  * Improved stability for utility management operations

This update focuses on making the CLI tool more self-sufficient by providing built-in
installation capabilities for required utilities, reducing the need for manual setup
and improving the overall user experience for new installations.