Overview
--------
Version 1.1.4 brings significant improvements to the command structure, help system, 
and adds version tracking functionality to improve the overall user experience and 
maintainability of the CLI tool.

New Features
-----------
- Version tracking system - Now properly tracks version information in settings.json
- Enhanced Help System:
  * Added comprehensive command-specific help (search help, get help, etc.)
  * Added -list-all option to display complete command reference
  * Improved command documentation with consistent formatting
- Improved Game Information:
  * Added version tracking for installed games
  * Added outdated detection to compare local game versions with server versions
- New "changelog" command - View version history with options:
  * changelog list - Show all available changelogs
  * changelog [version] - View changes for a specific version
  * changelog latest - View the most recent changes
- Improved File Trees - File trees now display with proper indentation and file sizes

Enhancements
-----------
- Command Interface Improvements:
  * More consistent error handling for invalid command usage
  * Better parameter parsing for complex commands
  * Improved command validation with clearer error messages
- Installation Improvements:
  * Better error handling during utility installation
  * Improved feedback during installation processes
- Game Management:
  * Enhanced list game command with better version detection
  * Added update status indicators (marks outdated games)
  * Improved game information display with hierarchical data
- Download Improvements:
  * Better error handling during downloads
  * Improved cancellation handling with Ctrl+Z
- Extraction Improvements:
  * Better error handling during extraction processes
  * More consistent feedback during extraction

Bug Fixes
---------
- Fixed issues with version checking and updates
- Fixed potential path handling issues
- Improved error handling throughout the application
- Fixed inconsistencies in command parsing
- Addressed potential issues with Unicode text handling

Technical Improvements
---------------------
- Added version property to settings.json
- Improved session metrics and tracking
- Better structured and organized code
- Enhanced logging for better troubleshooting
- More consistent error handling and user feedback
- Version change notification when updating from previous versions

Command System Overhaul
----------------------
- Standardized all command-specific help systems
- Improved validation for command parameters
- Better handling of base commands without parameters
- Structured command categories for better organization

This update focuses on improving the user experience through better command 
organization, more comprehensive help, and enhanced game version tracking 
capabilities.